"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.setupEnvironment = exports.addMatchers = exports.time = exports.cold = exports.hot = exports.resetTestScheduler = exports.initTestScheduler = exports.getTestScheduler = void 0;
var scheduler_1 = require("./src/scheduler");
var test_observables_1 = require("./src/test-observables");
var utils_1 = require("./src/utils");
var scheduler_2 = require("./src/scheduler");
Object.defineProperty(exports, "getTestScheduler", { enumerable: true, get: function () { return scheduler_2.getTestScheduler; } });
Object.defineProperty(exports, "initTestScheduler", { enumerable: true, get: function () { return scheduler_2.initTestScheduler; } });
Object.defineProperty(exports, "resetTestScheduler", { enumerable: true, get: function () { return scheduler_2.resetTestScheduler; } });
function hot(marbles, values, error) {
    return new test_observables_1.TestHotObservable(marbles.trim(), values, error);
}
exports.hot = hot;
function cold(marbles, values, error) {
    return new test_observables_1.TestColdObservable(marbles.trim(), values, error);
}
exports.cold = cold;
function time(marbles) {
    return scheduler_1.getTestScheduler().createTime(marbles.trim());
}
exports.time = time;
function addMatchers() {
    /**
     * expect.extend is an API exposed by jest-circus,
     * the default runner as of Jest v27. If that method
     * is not available, assume we're in a Jasmine test
     * environment.
     */
    if (!expect.extend) {
        jasmine.addMatchers({
            toHaveSubscriptions: function () { return ({
                compare: utils_1.toHaveSubscriptionsComparer,
            }); },
            toBeObservable: function (_utils) { return ({
                compare: utils_1.toBeObservableComparer,
            }); },
        });
    }
    else {
        expect.extend({
            toHaveSubscriptions: utils_1.toHaveSubscriptionsComparer,
            toBeObservable: utils_1.toBeObservableComparer,
        });
    }
}
exports.addMatchers = addMatchers;
function setupEnvironment() {
    beforeAll(function () { return addMatchers(); });
    beforeEach(function () { return scheduler_1.initTestScheduler(); });
    afterEach(function () {
        scheduler_1.getTestScheduler().flush();
        scheduler_1.resetTestScheduler();
    });
}
exports.setupEnvironment = setupEnvironment;
setupEnvironment();
//# sourceMappingURL=index.js.map