import { getTestScheduler, initTestScheduler, resetTestScheduler, } from './src/scheduler';
import { TestColdObservable, TestHotObservable, } from './src/test-observables';
import { toHaveSubscriptionsComparer, toBeObservableComparer, } from './src/utils';
export { getTestScheduler, initTestScheduler, resetTestScheduler, } from './src/scheduler';
export function hot(marbles, values, error) {
    return new TestHotObservable(marbles.trim(), values, error);
}
export function cold(marbles, values, error) {
    return new TestColdObservable(marbles.trim(), values, error);
}
export function time(marbles) {
    return getTestScheduler().createTime(marbles.trim());
}
export function addMatchers() {
    /**
     * expect.extend is an API exposed by jest-circus,
     * the default runner as of Jest v27. If that method
     * is not available, assume we're in a Jasmine test
     * environment.
     */
    if (!expect.extend) {
        jasmine.addMatchers({
            toHaveSubscriptions: () => ({
                compare: toHaveSubscriptionsComparer,
            }),
            toBeObservable: (_utils) => ({
                compare: toBeObservableComparer,
            }),
        });
    }
    else {
        expect.extend({
            toHaveSubscriptions: toHaveSubscriptionsComparer,
            toBeObservable: toBeObservableComparer,
        });
    }
}
export function setupEnvironment() {
    beforeAll(() => addMatchers());
    beforeEach(() => initTestScheduler());
    afterEach(() => {
        getTestScheduler().flush();
        resetTestScheduler();
    });
}
setupEnvironment();
//# sourceMappingURL=index.js.map