import { Injectable } from '@angular/core';
import * as i0 from "@angular/core";
/**
 * Additional options that can be passed to tryLogin.
 */
export class LoginOptions {
    constructor() {
        /**
         * Set this to true to disable the nonce
         * check which is used to avoid
         * replay attacks.
         * This flag should never be true in
         * production environments.
         */
        this.disableNonceCheck = false;
        /**
         * Normally, you want to clear your hash fragment after
         * the lib read the token(s) so that they are not displayed
         * anymore in the url. If not, set this to true. For code flow
         * this controls removing query string values.
         */
        this.preventClearHashAfterLogin = false;
    }
}
/**
 * Defines the logging interface the OAuthService uses
 * internally. Is compatible with the `console` object,
 * but you can provide your own implementation as well
 * through dependency injection.
 */
export class OAuthLogger {
}
/**
 * Defines a simple storage that can be used for
 * storing the tokens at client side.
 * Is compatible to localStorage and sessionStorage,
 * but you can also create your own implementations.
 */
export class OAuthStorage {
}
export class MemoryStorage {
    constructor() {
        this.data = new Map();
    }
    getItem(key) {
        return this.data.get(key);
    }
    removeItem(key) {
        this.data.delete(key);
    }
    setItem(key, data) {
        this.data.set(key, data);
    }
}
MemoryStorage.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "13.0.1", ngImport: i0, type: MemoryStorage, deps: [], target: i0.ɵɵFactoryTarget.Injectable });
MemoryStorage.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "13.0.1", ngImport: i0, type: MemoryStorage });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "13.0.1", ngImport: i0, type: MemoryStorage, decorators: [{
            type: Injectable
        }] });
/**
 * Represents the received tokens, the received state
 * and the parsed claims from the id-token.
 */
export class ReceivedTokens {
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidHlwZXMuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi9wcm9qZWN0cy9saWIvc3JjL3R5cGVzLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUFBLE9BQU8sRUFBRSxVQUFVLEVBQUUsTUFBTSxlQUFlLENBQUM7O0FBRTNDOztHQUVHO0FBQ0gsTUFBTSxPQUFPLFlBQVk7SUFBekI7UUE4Q0U7Ozs7OztXQU1HO1FBQ0gsc0JBQWlCLEdBQUksS0FBSyxDQUFDO1FBRTNCOzs7OztXQUtHO1FBQ0gsK0JBQTBCLEdBQUksS0FBSyxDQUFDO0lBUXRDLENBQUM7Q0FBQTtBQUVEOzs7OztHQUtHO0FBQ0gsTUFBTSxPQUFnQixXQUFXO0NBTWhDO0FBRUQ7Ozs7O0dBS0c7QUFDSCxNQUFNLE9BQWdCLFlBQVk7Q0FJakM7QUFHRCxNQUFNLE9BQU8sYUFBYTtJQUQxQjtRQUVVLFNBQUksR0FBRyxJQUFJLEdBQUcsRUFBa0IsQ0FBQztLQWExQztJQVhDLE9BQU8sQ0FBQyxHQUFXO1FBQ2pCLE9BQU8sSUFBSSxDQUFDLElBQUksQ0FBQyxHQUFHLENBQUMsR0FBRyxDQUFDLENBQUM7SUFDNUIsQ0FBQztJQUVELFVBQVUsQ0FBQyxHQUFXO1FBQ3BCLElBQUksQ0FBQyxJQUFJLENBQUMsTUFBTSxDQUFDLEdBQUcsQ0FBQyxDQUFDO0lBQ3hCLENBQUM7SUFFRCxPQUFPLENBQUMsR0FBVyxFQUFFLElBQVk7UUFDL0IsSUFBSSxDQUFDLElBQUksQ0FBQyxHQUFHLENBQUMsR0FBRyxFQUFFLElBQUksQ0FBQyxDQUFDO0lBQzNCLENBQUM7OzBHQWJVLGFBQWE7OEdBQWIsYUFBYTsyRkFBYixhQUFhO2tCQUR6QixVQUFVOztBQWlCWDs7O0dBR0c7QUFDSCxNQUFNLE9BQU8sY0FBYztDQUsxQiIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IEluamVjdGFibGUgfSBmcm9tICdAYW5ndWxhci9jb3JlJztcblxuLyoqXG4gKiBBZGRpdGlvbmFsIG9wdGlvbnMgdGhhdCBjYW4gYmUgcGFzc2VkIHRvIHRyeUxvZ2luLlxuICovXG5leHBvcnQgY2xhc3MgTG9naW5PcHRpb25zIHtcbiAgLyoqXG4gICAqIElzIGNhbGxlZCwgYWZ0ZXIgYSB0b2tlbiBoYXMgYmVlbiByZWNlaXZlZCBhbmRcbiAgICogc3VjY2Vzc2Z1bGx5IHZhbGlkYXRlZC5cbiAgICpcbiAgICogRGVwcmVjYXRlZDogIFVzZSBwcm9wZXJ0eSBgYGV2ZW50c2BgIG9uIE9BdXRoU2VydmljZSBpbnN0ZWFkLlxuICAgKi9cbiAgb25Ub2tlblJlY2VpdmVkPzogKHJlY2VpdmVkVG9rZW5zOiBSZWNlaXZlZFRva2VucykgPT4gdm9pZDtcblxuICAvKipcbiAgICogSG9vaywgdG8gdmFsaWRhdGUgdGhlIHJlY2VpdmVkIHRva2Vucy5cbiAgICpcbiAgICogRGVwcmVjYXRlZDogIFVzZSBwcm9wZXJ0eSBgYHRva2VuVmFsaWRhdGlvbkhhbmRsZXJgYCBvbiBPQXV0aFNlcnZpY2UgaW5zdGVhZC5cbiAgICovXG4gIHZhbGlkYXRpb25IYW5kbGVyPzogKHJlY2VpdmVkVG9rZW5zOiBSZWNlaXZlZFRva2VucykgPT4gUHJvbWlzZTxhbnk+O1xuXG4gIC8qKlxuICAgKiBDYWxsZWQgd2hlbiB0cnlMb2dpbiBkZXRlY3RzIHRoYXQgdGhlIGF1dGggc2VydmVyXG4gICAqIGluY2x1ZGVkIGFuIGVycm9yIG1lc3NhZ2UgaW50byB0aGUgaGFzaCBmcmFnbWVudC5cbiAgICpcbiAgICogRGVwcmVjYXRlZDogIFVzZSBwcm9wZXJ0eSBgYGV2ZW50c2BgIG9uIE9BdXRoU2VydmljZSBpbnN0ZWFkLlxuICAgKi9cbiAgb25Mb2dpbkVycm9yPzogKHBhcmFtczogb2JqZWN0KSA9PiB2b2lkO1xuXG4gIC8qKlxuICAgKiBBIGN1c3RvbSBoYXNoIGZyYWdtZW50IHRvIGJlIHVzZWQgaW5zdGVhZCBvZiB0aGVcbiAgICogYWN0dWFsIG9uZS4gVGhpcyBpcyB1c2VkIGZvciBzaWxlbnQgcmVmcmVzaGVzLCB0b1xuICAgKiBwYXNzIHRoZSBpZnJhbWVzIGhhc2ggZnJhZ21lbnQgdG8gdGhpcyBtZXRob2QsIGFuZFxuICAgKiBpcyBhbHNvIHVzZWQgYnkgcG9wdXAgZmxvd3MgaW4gdGhlIHNhbWUgbWFubmVyLlxuICAgKiBUaGlzIGNhbiBiZSB1c2VkIHdpdGggY29kZSBmbG93LCB3aGVyZSBpcyBtdXN0IGJlIHNldFxuICAgKiB0byBhIGhhc2ggc3ltYm9sIGZvbGxvd2VkIGJ5IHRoZSBxdWVyeXN0cmluZy4gVGhlXG4gICAqIHF1ZXN0aW9uIG1hcmsgaXMgb3B0aW9uYWwsIGJ1dCBtYXkgYmUgcHJlc2VudCBmb2xsb3dpbmdcbiAgICogdGhlIGhhc2ggc3ltYm9sLlxuICAgKi9cbiAgY3VzdG9tSGFzaEZyYWdtZW50Pzogc3RyaW5nO1xuXG4gIC8qKlxuICAgKiBTZXQgdGhpcyB0byB0cnVlIHRvIGRpc2FibGUgdGhlIG9hdXRoMiBzdGF0ZVxuICAgKiBjaGVjayB3aGljaCBpcyBhIGJlc3QgcHJhY3RpY2UgdG8gYXZvaWRcbiAgICogc2VjdXJpdHkgYXR0YWNrcy5cbiAgICogQXMgT0lEQyBkZWZpbmVzIGEgbm9uY2UgY2hlY2sgdGhhdCBpbmNsdWRlc1xuICAgKiB0aGlzLCB0aGlzIGNhbiBiZSBzZXQgdG8gdHJ1ZSB3aGVuIG9ubHkgZG9pbmdcbiAgICogT0lEQy5cbiAgICovXG4gIGRpc2FibGVPQXV0aDJTdGF0ZUNoZWNrPzogYm9vbGVhbjtcblxuICAvKipcbiAgICogU2V0IHRoaXMgdG8gdHJ1ZSB0byBkaXNhYmxlIHRoZSBub25jZVxuICAgKiBjaGVjayB3aGljaCBpcyB1c2VkIHRvIGF2b2lkXG4gICAqIHJlcGxheSBhdHRhY2tzLlxuICAgKiBUaGlzIGZsYWcgc2hvdWxkIG5ldmVyIGJlIHRydWUgaW5cbiAgICogcHJvZHVjdGlvbiBlbnZpcm9ubWVudHMuXG4gICAqL1xuICBkaXNhYmxlTm9uY2VDaGVjaz8gPSBmYWxzZTtcblxuICAvKipcbiAgICogTm9ybWFsbHksIHlvdSB3YW50IHRvIGNsZWFyIHlvdXIgaGFzaCBmcmFnbWVudCBhZnRlclxuICAgKiB0aGUgbGliIHJlYWQgdGhlIHRva2VuKHMpIHNvIHRoYXQgdGhleSBhcmUgbm90IGRpc3BsYXllZFxuICAgKiBhbnltb3JlIGluIHRoZSB1cmwuIElmIG5vdCwgc2V0IHRoaXMgdG8gdHJ1ZS4gRm9yIGNvZGUgZmxvd1xuICAgKiB0aGlzIGNvbnRyb2xzIHJlbW92aW5nIHF1ZXJ5IHN0cmluZyB2YWx1ZXMuXG4gICAqL1xuICBwcmV2ZW50Q2xlYXJIYXNoQWZ0ZXJMb2dpbj8gPSBmYWxzZTtcblxuICAvKipcbiAgICogU2V0IHRoaXMgZm9yIGNvZGUgZmxvdyBpZiB5b3UgdXNlZCBhIGN1c3RvbSByZWRpcmVjdCBVcmlcbiAgICogd2hlbiByZXRyaWV2aW5nIHRoZSBjb2RlLiBUaGlzIGlzIHVzZWQgaW50ZXJuYWxseSBmb3Igc2lsZW50XG4gICAqIHJlZnJlc2ggYW5kIHBvcHVwIGZsb3dzLlxuICAgKi9cbiAgY3VzdG9tUmVkaXJlY3RVcmk/OiBzdHJpbmc7XG59XG5cbi8qKlxuICogRGVmaW5lcyB0aGUgbG9nZ2luZyBpbnRlcmZhY2UgdGhlIE9BdXRoU2VydmljZSB1c2VzXG4gKiBpbnRlcm5hbGx5LiBJcyBjb21wYXRpYmxlIHdpdGggdGhlIGBjb25zb2xlYCBvYmplY3QsXG4gKiBidXQgeW91IGNhbiBwcm92aWRlIHlvdXIgb3duIGltcGxlbWVudGF0aW9uIGFzIHdlbGxcbiAqIHRocm91Z2ggZGVwZW5kZW5jeSBpbmplY3Rpb24uXG4gKi9cbmV4cG9ydCBhYnN0cmFjdCBjbGFzcyBPQXV0aExvZ2dlciB7XG4gIGFic3RyYWN0IGRlYnVnKG1lc3NhZ2U/OiBhbnksIC4uLm9wdGlvbmFsUGFyYW1zOiBhbnlbXSk6IHZvaWQ7XG4gIGFic3RyYWN0IGluZm8obWVzc2FnZT86IGFueSwgLi4ub3B0aW9uYWxQYXJhbXM6IGFueVtdKTogdm9pZDtcbiAgYWJzdHJhY3QgbG9nKG1lc3NhZ2U/OiBhbnksIC4uLm9wdGlvbmFsUGFyYW1zOiBhbnlbXSk6IHZvaWQ7XG4gIGFic3RyYWN0IHdhcm4obWVzc2FnZT86IGFueSwgLi4ub3B0aW9uYWxQYXJhbXM6IGFueVtdKTogdm9pZDtcbiAgYWJzdHJhY3QgZXJyb3IobWVzc2FnZT86IGFueSwgLi4ub3B0aW9uYWxQYXJhbXM6IGFueVtdKTogdm9pZDtcbn1cblxuLyoqXG4gKiBEZWZpbmVzIGEgc2ltcGxlIHN0b3JhZ2UgdGhhdCBjYW4gYmUgdXNlZCBmb3JcbiAqIHN0b3JpbmcgdGhlIHRva2VucyBhdCBjbGllbnQgc2lkZS5cbiAqIElzIGNvbXBhdGlibGUgdG8gbG9jYWxTdG9yYWdlIGFuZCBzZXNzaW9uU3RvcmFnZSxcbiAqIGJ1dCB5b3UgY2FuIGFsc28gY3JlYXRlIHlvdXIgb3duIGltcGxlbWVudGF0aW9ucy5cbiAqL1xuZXhwb3J0IGFic3RyYWN0IGNsYXNzIE9BdXRoU3RvcmFnZSB7XG4gIGFic3RyYWN0IGdldEl0ZW0oa2V5OiBzdHJpbmcpOiBzdHJpbmcgfCBudWxsO1xuICBhYnN0cmFjdCByZW1vdmVJdGVtKGtleTogc3RyaW5nKTogdm9pZDtcbiAgYWJzdHJhY3Qgc2V0SXRlbShrZXk6IHN0cmluZywgZGF0YTogc3RyaW5nKTogdm9pZDtcbn1cblxuQEluamVjdGFibGUoKVxuZXhwb3J0IGNsYXNzIE1lbW9yeVN0b3JhZ2UgaW1wbGVtZW50cyBPQXV0aFN0b3JhZ2Uge1xuICBwcml2YXRlIGRhdGEgPSBuZXcgTWFwPHN0cmluZywgc3RyaW5nPigpO1xuXG4gIGdldEl0ZW0oa2V5OiBzdHJpbmcpOiBzdHJpbmcge1xuICAgIHJldHVybiB0aGlzLmRhdGEuZ2V0KGtleSk7XG4gIH1cblxuICByZW1vdmVJdGVtKGtleTogc3RyaW5nKTogdm9pZCB7XG4gICAgdGhpcy5kYXRhLmRlbGV0ZShrZXkpO1xuICB9XG5cbiAgc2V0SXRlbShrZXk6IHN0cmluZywgZGF0YTogc3RyaW5nKTogdm9pZCB7XG4gICAgdGhpcy5kYXRhLnNldChrZXksIGRhdGEpO1xuICB9XG59XG5cbi8qKlxuICogUmVwcmVzZW50cyB0aGUgcmVjZWl2ZWQgdG9rZW5zLCB0aGUgcmVjZWl2ZWQgc3RhdGVcbiAqIGFuZCB0aGUgcGFyc2VkIGNsYWltcyBmcm9tIHRoZSBpZC10b2tlbi5cbiAqL1xuZXhwb3J0IGNsYXNzIFJlY2VpdmVkVG9rZW5zIHtcbiAgaWRUb2tlbjogc3RyaW5nO1xuICBhY2Nlc3NUb2tlbjogc3RyaW5nO1xuICBpZENsYWltcz86IG9iamVjdDtcbiAgc3RhdGU/OiBzdHJpbmc7XG59XG5cbi8qKlxuICogUmVwcmVzZW50cyB0aGUgcGFyc2VkIGFuZCB2YWxpZGF0ZWQgaWRfdG9rZW4uXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgUGFyc2VkSWRUb2tlbiB7XG4gIGlkVG9rZW46IHN0cmluZztcbiAgaWRUb2tlbkNsYWltczogb2JqZWN0O1xuICBpZFRva2VuSGVhZGVyOiBvYmplY3Q7XG4gIGlkVG9rZW5DbGFpbXNKc29uOiBzdHJpbmc7XG4gIGlkVG9rZW5IZWFkZXJKc29uOiBzdHJpbmc7XG4gIGlkVG9rZW5FeHBpcmVzQXQ6IG51bWJlcjtcbn1cblxuLyoqXG4gKiBSZXByZXNlbnRzIHRoZSByZXNwb25zZSBmcm9tIHRoZSB0b2tlbiBlbmRwb2ludFxuICogaHR0cDovL29wZW5pZC5uZXQvc3BlY3Mvb3BlbmlkLWNvbm5lY3QtY29yZS0xXzAuaHRtbCNUb2tlbkVuZHBvaW50XG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgVG9rZW5SZXNwb25zZSB7XG4gIGFjY2Vzc190b2tlbjogc3RyaW5nO1xuICBpZF90b2tlbjogc3RyaW5nO1xuICB0b2tlbl90eXBlOiBzdHJpbmc7XG4gIGV4cGlyZXNfaW46IG51bWJlcjtcbiAgcmVmcmVzaF90b2tlbjogc3RyaW5nO1xuICBzY29wZTogc3RyaW5nO1xuICBzdGF0ZT86IHN0cmluZztcbn1cblxuLyoqXG4gKiBSZXByZXNlbnRzIHRoZSByZXNwb25zZSBmcm9tIHRoZSB1c2VyIGluZm8gZW5kcG9pbnRcbiAqIGh0dHA6Ly9vcGVuaWQubmV0L3NwZWNzL29wZW5pZC1jb25uZWN0LWNvcmUtMV8wLmh0bWwjVXNlckluZm9cbiAqL1xuZXhwb3J0IGludGVyZmFjZSBVc2VySW5mbyB7XG4gIHN1Yjogc3RyaW5nO1xuICBba2V5OiBzdHJpbmddOiBhbnk7XG59XG5cbi8qKlxuICogUmVwcmVzZW50cyBhbiBPcGVuSUQgQ29ubmVjdCBkaXNjb3ZlcnkgZG9jdW1lbnRcbiAqL1xuZXhwb3J0IGludGVyZmFjZSBPaWRjRGlzY292ZXJ5RG9jIHtcbiAgaXNzdWVyOiBzdHJpbmc7XG4gIGF1dGhvcml6YXRpb25fZW5kcG9pbnQ6IHN0cmluZztcbiAgdG9rZW5fZW5kcG9pbnQ6IHN0cmluZztcbiAgdG9rZW5fZW5kcG9pbnRfYXV0aF9tZXRob2RzX3N1cHBvcnRlZDogc3RyaW5nW107XG4gIHRva2VuX2VuZHBvaW50X2F1dGhfc2lnbmluZ19hbGdfdmFsdWVzX3N1cHBvcnRlZDogc3RyaW5nW107XG4gIHVzZXJpbmZvX2VuZHBvaW50OiBzdHJpbmc7XG4gIGNoZWNrX3Nlc3Npb25faWZyYW1lOiBzdHJpbmc7XG4gIGVuZF9zZXNzaW9uX2VuZHBvaW50OiBzdHJpbmc7XG4gIGp3a3NfdXJpOiBzdHJpbmc7XG4gIHJlZ2lzdHJhdGlvbl9lbmRwb2ludDogc3RyaW5nO1xuICBzY29wZXNfc3VwcG9ydGVkOiBzdHJpbmdbXTtcbiAgcmVzcG9uc2VfdHlwZXNfc3VwcG9ydGVkOiBzdHJpbmdbXTtcbiAgYWNyX3ZhbHVlc19zdXBwb3J0ZWQ6IHN0cmluZ1tdO1xuICByZXNwb25zZV9tb2Rlc19zdXBwb3J0ZWQ6IHN0cmluZ1tdO1xuICBncmFudF90eXBlc19zdXBwb3J0ZWQ6IHN0cmluZ1tdO1xuICBzdWJqZWN0X3R5cGVzX3N1cHBvcnRlZDogc3RyaW5nW107XG4gIHVzZXJpbmZvX3NpZ25pbmdfYWxnX3ZhbHVlc19zdXBwb3J0ZWQ6IHN0cmluZ1tdO1xuICB1c2VyaW5mb19lbmNyeXB0aW9uX2FsZ192YWx1ZXNfc3VwcG9ydGVkOiBzdHJpbmdbXTtcbiAgdXNlcmluZm9fZW5jcnlwdGlvbl9lbmNfdmFsdWVzX3N1cHBvcnRlZDogc3RyaW5nW107XG4gIGlkX3Rva2VuX3NpZ25pbmdfYWxnX3ZhbHVlc19zdXBwb3J0ZWQ6IHN0cmluZ1tdO1xuICBpZF90b2tlbl9lbmNyeXB0aW9uX2FsZ192YWx1ZXNfc3VwcG9ydGVkOiBzdHJpbmdbXTtcbiAgaWRfdG9rZW5fZW5jcnlwdGlvbl9lbmNfdmFsdWVzX3N1cHBvcnRlZDogc3RyaW5nW107XG4gIHJlcXVlc3Rfb2JqZWN0X3NpZ25pbmdfYWxnX3ZhbHVlc19zdXBwb3J0ZWQ6IHN0cmluZ1tdO1xuICBkaXNwbGF5X3ZhbHVlc19zdXBwb3J0ZWQ6IHN0cmluZ1tdO1xuICBjbGFpbV90eXBlc19zdXBwb3J0ZWQ6IHN0cmluZ1tdO1xuICBjbGFpbXNfc3VwcG9ydGVkOiBzdHJpbmdbXTtcbiAgY2xhaW1zX3BhcmFtZXRlcl9zdXBwb3J0ZWQ6IGJvb2xlYW47XG4gIHNlcnZpY2VfZG9jdW1lbnRhdGlvbjogc3RyaW5nO1xuICB1aV9sb2NhbGVzX3N1cHBvcnRlZDogc3RyaW5nW107XG4gIHJldm9jYXRpb25fZW5kcG9pbnQ6IHN0cmluZztcbn1cbiJdfQ==