export declare class AuthConfig {
    /**
     * The client's id as registered with the auth server
     */
    clientId?: string;
    /**
     * The client's redirectUri as registered with the auth server
     */
    redirectUri?: string;
    /**
     * An optional second redirectUri where the auth server
     * redirects the user to after logging out.
     */
    postLogoutRedirectUri?: string;
    /**
     * Defines whether to use 'redirectUri' as a replacement
     * of 'postLogoutRedirectUri' if the latter is not set.
     */
    redirectUriAsPostLogoutRedirectUriFallback?: boolean;
    /**
     * The auth server's endpoint that allows to log
     * the user in when using implicit flow.
     */
    loginUrl?: string;
    /**
     * The requested scopes
     */
    scope?: string;
    resource?: string;
    rngUrl?: string;
    /**
     * Defines whether to use OpenId Connect during
     * implicit flow.
     */
    oidc?: boolean;
    /**
     * Defines whether to request an access token during
     * implicit flow.
     */
    requestAccessToken?: boolean;
    options?: any;
    /**
     * The issuer's uri.
     */
    issuer?: string;
    /**
     * The logout url.
     */
    logoutUrl?: string;
    /**
     * Defines whether to clear the hash fragment after logging in.
     */
    clearHashAfterLogin?: boolean;
    /**
     * Url of the token endpoint as defined by OpenId Connect and OAuth 2.
     */
    tokenEndpoint?: string;
    /**
     * Url of the revocation endpoint as defined by OpenId Connect and OAuth 2.
     */
    revocationEndpoint?: string;
    /**
     * Names of known parameters sent out in the TokenResponse. https://tools.ietf.org/html/rfc6749#section-5.1
     */
    customTokenParameters?: string[];
    /**
     * Url of the userinfo endpoint as defined by OpenId Connect.
     */
    userinfoEndpoint?: string;
    responseType?: string;
    /**
     * Defines whether additional debug information should
     * be shown at the console. Note that in certain browsers
     * the verbosity of the console needs to be explicitly set
     * to include Debug level messages.
     */
    showDebugInformation?: boolean;
    /**
     * The redirect uri used when doing silent refresh.
     */
    silentRefreshRedirectUri?: string;
    silentRefreshMessagePrefix?: string;
    /**
     * Set this to true to display the iframe used for
     * silent refresh for debugging.
     */
    silentRefreshShowIFrame?: boolean;
    /**
     * Timeout for silent refresh.
     * @internal
     * depreacted b/c of typo, see silentRefreshTimeout
     */
    siletRefreshTimeout?: number;
    /**
     * Timeout for silent refresh.
     */
    silentRefreshTimeout?: number;
    /**
     * Some auth servers don't allow using password flow
     * w/o a client secret while the standards do not
     * demand for it. In this case, you can set a password
     * here. As this password is exposed to the public
     * it does not bring additional security and is therefore
     * as good as using no password.
     */
    dummyClientSecret?: string;
    /**
     * Defines whether https is required.
     * The default value is remoteOnly which only allows
     * http for localhost, while every other domains need
     * to be used with https.
     */
    requireHttps?: boolean | 'remoteOnly';
    /**
     * Defines whether every url provided by the discovery
     * document has to start with the issuer's url.
     */
    strictDiscoveryDocumentValidation?: boolean;
    /**
     * JSON Web Key Set (https://tools.ietf.org/html/rfc7517)
     * with keys used to validate received id_tokens.
     * This is taken out of the disovery document. Can be set manually too.
     */
    jwks?: object;
    /**
     * Map with additional query parameter that are appended to
     * the request when initializing implicit flow.
     */
    customQueryParams?: object;
    silentRefreshIFrameName?: string;
    /**
     * Defines when the token_timeout event should be raised.
     * If you set this to the default value 0.75, the event
     * is triggered after 75% of the token's life time.
     */
    timeoutFactor?: number;
    /**
     * If true, the lib will try to check whether the user
     * is still logged in on a regular basis as described
     * in http://openid.net/specs/openid-connect-session-1_0.html#ChangeNotification
     */
    sessionChecksEnabled?: boolean;
    /**
     * Interval in msec for checking the session
     * according to http://openid.net/specs/openid-connect-session-1_0.html#ChangeNotification
     */
    sessionCheckIntervall?: number;
    /**
     * Url for the iframe used for session checks
     */
    sessionCheckIFrameUrl?: string;
    /**
     * Name of the iframe to use for session checks
     */
    sessionCheckIFrameName?: string;
    /**
     * This property has been introduced to disable at_hash checks
     * and is indented for Identity Provider that does not deliver
     * an at_hash EVEN THOUGH its recommended by the OIDC specs.
     * Of course, when disabling these checks then we are bypassing
     * a security check which means we are more vulnerable.
     */
    disableAtHashCheck?: boolean;
    /**
     * Defines wether to check the subject of a refreshed token after silent refresh.
     * Normally, it should be the same as before.
     */
    skipSubjectCheck?: boolean;
    useIdTokenHintForSilentRefresh?: boolean;
    /**
     * Defined whether to skip the validation of the issuer in the discovery document.
     * Normally, the discovey document's url starts with the url of the issuer.
     */
    skipIssuerCheck?: boolean;
    /**
     * According to rfc6749 it is recommended (but not required) that the auth
     * server exposes the access_token's life time in seconds.
     * This is a fallback value for the case this value is not exposed.
     */
    fallbackAccessTokenExpirationTimeInSec?: number;
    /**
     * final state sent to issuer is built as follows:
     * state = nonce + nonceStateSeparator + additional state
     * Default separator is ';' (encoded %3B).
     * In rare cases, this character might be forbidden or inconvenient to use by the issuer so it can be customized.
     */
    nonceStateSeparator?: string;
    /**
     * Set this to true to use HTTP BASIC auth for AJAX calls
     */
    useHttpBasicAuth?: boolean;
    /**
     * The window of time (in seconds) to allow the current time to deviate when validating id_token's iat and exp values.
     */
    clockSkewInSec?: number;
    /**
     * The interceptors waits this time span if there is no token
     */
    waitForTokenInMsec?: number;
    /**
     * Set this to true if you want to use silent refresh together with
     * code flow. As silent refresh is the only option for refreshing
     * with implicit flow, you don't need to explicitly turn it on in
     * this case.
     */
    useSilentRefresh?: any;
    /**
     * Code Flow is by defauld used together with PKCI which is also higly recommented.
     * You can disbale it here by setting this flag to true.
     * https://tools.ietf.org/html/rfc7636#section-1.1
     */
    disablePKCE?: boolean;
    /**
     * Set this to true to preserve the requested route including query parameters after code flow login.
     * This setting enables deep linking for the code flow.
     */
    preserveRequestedRoute?: boolean;
    constructor(json?: Partial<AuthConfig>);
    /**
     * This property allows you to override the method that is used to open the login url,
     * allowing a way for implementations to specify their own method of routing to new
     * urls.
     */
    openUri?: (uri: string) => void;
}
