import { EventEmitter, TemplateRef } from '@angular/core';
import { ColorHelper } from '../common/color.helper';
import { BaseChartComponent } from '../common/base-chart.component';
import { LegendPosition } from '../common/types/legend.model';
import { ScaleType } from '../common/types/scale-type.enum';
import { ViewDimensions } from '../common/types/view-dimension.interface';
import { Orientation } from '../common/types/orientation.enum';
import * as i0 from "@angular/core";
export declare class PolarChartComponent extends BaseChartComponent {
    legend: boolean;
    legendTitle: string;
    legendPosition: LegendPosition;
    xAxis: boolean;
    yAxis: boolean;
    showXAxisLabel: boolean;
    showYAxisLabel: boolean;
    xAxisLabel: string;
    yAxisLabel: string;
    autoScale: boolean;
    showGridLines: boolean;
    curve: any;
    activeEntries: any[];
    schemeType: ScaleType;
    rangeFillOpacity: number;
    trimYAxisTicks: boolean;
    maxYAxisTickLength: number;
    xAxisTickFormatting: (o: any) => any;
    yAxisTickFormatting: (o: any) => any;
    roundDomains: boolean;
    tooltipDisabled: boolean;
    showSeriesOnHover: boolean;
    gradient: boolean;
    yAxisMinScale: number;
    labelTrim: boolean;
    labelTrimSize: number;
    activate: EventEmitter<any>;
    deactivate: EventEmitter<any>;
    tooltipTemplate: TemplateRef<any>;
    dims: ViewDimensions;
    yAxisDims: ViewDimensions;
    labelOffset: number;
    xDomain: any;
    yDomain: any;
    seriesDomain: any;
    yScale: any;
    xScale: any;
    yAxisScale: any;
    colors: ColorHelper;
    scaleType: ScaleType;
    transform: string;
    transformPlot: string;
    transformYAxis: string;
    transformXAxis: string;
    margin: number[];
    xAxisHeight: number;
    yAxisWidth: number;
    filteredDomain: any;
    legendOptions: any;
    thetaTicks: any[];
    radiusTicks: number[];
    outerRadius: number;
    orientation: typeof Orientation;
    isSSR: boolean;
    ngOnInit(): void;
    update(): void;
    setDims(): void;
    setScales(): void;
    setTicks(): void;
    getXValues(): any[];
    getXDomain(values?: any[]): any[];
    getYValues(): any[];
    getYDomain(domain?: any[]): any[];
    getSeriesDomain(): any[];
    getXScale(domain: any, width: number): any;
    getYScale(domain: any, height: number): any;
    onClick(data: any, series?: any): void;
    setColors(): void;
    getLegendOptions(): {
        scaleType: ScaleType.Ordinal;
        colors: ColorHelper;
        domain: any;
        title: string;
        position: LegendPosition;
    } | {
        scaleType: ScaleType.Time | ScaleType.Linear | ScaleType.Quantile;
        colors: any;
        domain: any;
        title: any;
        position: LegendPosition;
    };
    updateYAxisWidth({ width }: {
        width: number;
    }): void;
    updateXAxisHeight({ height }: {
        height: number;
    }): void;
    onActivate(item: any): void;
    onDeactivate(item: any): void;
    deactivateAll(): void;
    trackBy(index: number, item: any): string;
    static ɵfac: i0.ɵɵFactoryDeclaration<PolarChartComponent, never>;
    static ɵcmp: i0.ɵɵComponentDeclaration<PolarChartComponent, "ngx-charts-polar-chart", never, { "legend": "legend"; "legendTitle": "legendTitle"; "legendPosition": "legendPosition"; "xAxis": "xAxis"; "yAxis": "yAxis"; "showXAxisLabel": "showXAxisLabel"; "showYAxisLabel": "showYAxisLabel"; "xAxisLabel": "xAxisLabel"; "yAxisLabel": "yAxisLabel"; "autoScale": "autoScale"; "showGridLines": "showGridLines"; "curve": "curve"; "activeEntries": "activeEntries"; "schemeType": "schemeType"; "rangeFillOpacity": "rangeFillOpacity"; "trimYAxisTicks": "trimYAxisTicks"; "maxYAxisTickLength": "maxYAxisTickLength"; "xAxisTickFormatting": "xAxisTickFormatting"; "yAxisTickFormatting": "yAxisTickFormatting"; "roundDomains": "roundDomains"; "tooltipDisabled": "tooltipDisabled"; "showSeriesOnHover": "showSeriesOnHover"; "gradient": "gradient"; "yAxisMinScale": "yAxisMinScale"; "labelTrim": "labelTrim"; "labelTrimSize": "labelTrimSize"; }, { "activate": "activate"; "deactivate": "deactivate"; }, ["tooltipTemplate"], never>;
}
