import { SimpleChanges, EventEmitter, OnChanges, TemplateRef } from '@angular/core';
import { ColorHelper } from '../common/color.helper';
import { DataItem } from '../models/chart-data.model';
import { PieData } from './pie-label.component';
import { PlacementTypes } from '../common/tooltip/position';
import { StyleTypes } from '../common/tooltip/style.type';
import { ViewDimensions } from '../common/types/view-dimension.interface';
import * as i0 from "@angular/core";
export declare class PieSeriesComponent implements OnChanges {
    colors: ColorHelper;
    series: DataItem[];
    dims: ViewDimensions;
    innerRadius: number;
    outerRadius: number;
    explodeSlices: boolean;
    showLabels: boolean;
    gradient: boolean;
    activeEntries: any[];
    labelFormatting: any;
    trimLabels: boolean;
    maxLabelLength: number;
    tooltipText: (o: any) => any;
    tooltipDisabled: boolean;
    tooltipTemplate: TemplateRef<any>;
    animations: boolean;
    select: EventEmitter<any>;
    activate: EventEmitter<any>;
    deactivate: EventEmitter<any>;
    dblclick: EventEmitter<any>;
    max: number;
    data: PieData[];
    placementTypes: typeof PlacementTypes;
    styleTypes: typeof StyleTypes;
    ngOnChanges(changes: SimpleChanges): void;
    update(): void;
    midAngle(d: any): number;
    outerArc(): any;
    calculateLabelPositions(pieData: any): any;
    labelVisible(myArc: any): boolean;
    getTooltipTitle(a: any): any;
    labelText(myArc: any): string;
    label(myArc: any): string;
    defaultTooltipText(myArc: any): string;
    color(myArc: any): any;
    trackBy(index: any, item: any): string;
    onClick(data: any): void;
    isActive(entry: any): boolean;
    static ɵfac: i0.ɵɵFactoryDeclaration<PieSeriesComponent, never>;
    static ɵcmp: i0.ɵɵComponentDeclaration<PieSeriesComponent, "g[ngx-charts-pie-series]", never, { "colors": "colors"; "series": "series"; "dims": "dims"; "innerRadius": "innerRadius"; "outerRadius": "outerRadius"; "explodeSlices": "explodeSlices"; "showLabels": "showLabels"; "gradient": "gradient"; "activeEntries": "activeEntries"; "labelFormatting": "labelFormatting"; "trimLabels": "trimLabels"; "maxLabelLength": "maxLabelLength"; "tooltipText": "tooltipText"; "tooltipDisabled": "tooltipDisabled"; "tooltipTemplate": "tooltipTemplate"; "animations": "animations"; }, { "select": "select"; "activate": "activate"; "deactivate": "deactivate"; "dblclick": "dblclick"; }, never, never>;
}
