import { EventEmitter, TemplateRef } from '@angular/core';
import { ColorHelper } from '../common/color.helper';
import { BaseChartComponent } from '../common/base-chart.component';
import { DataItem } from '../models/chart-data.model';
import { LegendOptions, LegendPosition } from '../common/types/legend.model';
import { ViewDimensions } from '../common/types/view-dimension.interface';
import * as i0 from "@angular/core";
export declare class PieChartComponent extends BaseChartComponent {
    labels: boolean;
    legend: boolean;
    legendTitle: string;
    legendPosition: LegendPosition;
    explodeSlices: boolean;
    doughnut: boolean;
    arcWidth: number;
    gradient: boolean;
    activeEntries: any[];
    tooltipDisabled: boolean;
    labelFormatting: any;
    trimLabels: boolean;
    maxLabelLength: number;
    tooltipText: any;
    dblclick: EventEmitter<any>;
    margins: number[];
    select: EventEmitter<any>;
    activate: EventEmitter<any>;
    deactivate: EventEmitter<any>;
    tooltipTemplate: TemplateRef<any>;
    translation: string;
    outerRadius: number;
    innerRadius: number;
    data: DataItem[];
    colors: ColorHelper;
    domain: string[];
    dims: ViewDimensions;
    legendOptions: LegendOptions;
    update(): void;
    getDomain(): string[];
    onClick(data: DataItem | string): void;
    setColors(): void;
    getLegendOptions(): LegendOptions;
    onActivate(item: any, fromLegend?: boolean): void;
    onDeactivate(item: any, fromLegend?: boolean): void;
    private hasNoOptionalMarginsSet;
    static ɵfac: i0.ɵɵFactoryDeclaration<PieChartComponent, never>;
    static ɵcmp: i0.ɵɵComponentDeclaration<PieChartComponent, "ngx-charts-pie-chart", never, { "labels": "labels"; "legend": "legend"; "legendTitle": "legendTitle"; "legendPosition": "legendPosition"; "explodeSlices": "explodeSlices"; "doughnut": "doughnut"; "arcWidth": "arcWidth"; "gradient": "gradient"; "activeEntries": "activeEntries"; "tooltipDisabled": "tooltipDisabled"; "labelFormatting": "labelFormatting"; "trimLabels": "trimLabels"; "maxLabelLength": "maxLabelLength"; "tooltipText": "tooltipText"; "margins": "margins"; }, { "dblclick": "dblclick"; "select": "select"; "activate": "activate"; "deactivate": "deactivate"; }, ["tooltipTemplate"], never>;
}
