import { EventEmitter, TemplateRef } from '@angular/core';
import { BaseChartComponent } from '../common/base-chart.component';
import { ColorHelper } from '../common/color.helper';
import { BubbleChartSeries } from '../models/chart-data.model';
import { LegendOptions, LegendPosition } from '../common/types/legend.model';
import { ScaleType } from '../common/types/scale-type.enum';
import { ViewDimensions } from '../common/types/view-dimension.interface';
import * as i0 from "@angular/core";
export declare class BubbleChartComponent extends BaseChartComponent {
    showGridLines: boolean;
    legend: boolean;
    legendTitle: string;
    legendPosition: LegendPosition;
    xAxis: boolean;
    yAxis: boolean;
    showXAxisLabel: boolean;
    showYAxisLabel: boolean;
    xAxisLabel: string;
    yAxisLabel: string;
    trimXAxisTicks: boolean;
    trimYAxisTicks: boolean;
    rotateXAxisTicks: boolean;
    maxXAxisTickLength: number;
    maxYAxisTickLength: number;
    xAxisTickFormatting: any;
    yAxisTickFormatting: any;
    xAxisTicks: any[];
    yAxisTicks: any[];
    roundDomains: boolean;
    maxRadius: number;
    minRadius: number;
    autoScale: boolean;
    schemeType: ScaleType;
    tooltipDisabled: boolean;
    xScaleMin: number;
    xScaleMax: number;
    yScaleMin: number;
    yScaleMax: number;
    activate: EventEmitter<any>;
    deactivate: EventEmitter<any>;
    tooltipTemplate: TemplateRef<any>;
    dims: ViewDimensions;
    colors: ColorHelper;
    scaleType: ScaleType;
    margin: number[];
    bubblePadding: number[];
    data: BubbleChartSeries[];
    legendOptions: LegendOptions;
    transform: string;
    clipPath: string;
    clipPathId: string;
    seriesDomain: number[];
    xDomain: number[];
    yDomain: number[];
    rDomain: number[];
    xScaleType: ScaleType;
    yScaleType: ScaleType;
    yScale: any;
    xScale: any;
    rScale: any;
    xAxisHeight: number;
    yAxisWidth: number;
    activeEntries: any[];
    isSSR: boolean;
    ngOnInit(): void;
    update(): void;
    hideCircles(): void;
    onClick(data: any, series?: any): void;
    getBubblePadding(): number[];
    setScales(): void;
    getYScale(domain: any, height: number): any;
    getXScale(domain: any, width: number): any;
    getRScale(domain: any, range: any): any;
    getLegendOptions(): LegendOptions;
    getXDomain(): number[];
    getYDomain(): number[];
    getRDomain(): [number, number];
    updateYAxisWidth({ width }: {
        width: number;
    }): void;
    updateXAxisHeight({ height }: {
        height: number;
    }): void;
    onActivate(item: any): void;
    onDeactivate(item: any): void;
    deactivateAll(): void;
    trackBy(index: number, item: any): string;
    static ɵfac: i0.ɵɵFactoryDeclaration<BubbleChartComponent, never>;
    static ɵcmp: i0.ɵɵComponentDeclaration<BubbleChartComponent, "ngx-charts-bubble-chart", never, { "showGridLines": "showGridLines"; "legend": "legend"; "legendTitle": "legendTitle"; "legendPosition": "legendPosition"; "xAxis": "xAxis"; "yAxis": "yAxis"; "showXAxisLabel": "showXAxisLabel"; "showYAxisLabel": "showYAxisLabel"; "xAxisLabel": "xAxisLabel"; "yAxisLabel": "yAxisLabel"; "trimXAxisTicks": "trimXAxisTicks"; "trimYAxisTicks": "trimYAxisTicks"; "rotateXAxisTicks": "rotateXAxisTicks"; "maxXAxisTickLength": "maxXAxisTickLength"; "maxYAxisTickLength": "maxYAxisTickLength"; "xAxisTickFormatting": "xAxisTickFormatting"; "yAxisTickFormatting": "yAxisTickFormatting"; "xAxisTicks": "xAxisTicks"; "yAxisTicks": "yAxisTicks"; "roundDomains": "roundDomains"; "maxRadius": "maxRadius"; "minRadius": "minRadius"; "autoScale": "autoScale"; "schemeType": "schemeType"; "tooltipDisabled": "tooltipDisabled"; "xScaleMin": "xScaleMin"; "xScaleMax": "xScaleMax"; "yScaleMin": "yScaleMin"; "yScaleMax": "yScaleMax"; }, { "activate": "activate"; "deactivate": "deactivate"; }, ["tooltipTemplate"], never>;
}
