import { EventEmitter, OnChanges, TemplateRef } from '@angular/core';
import { DataItem, StringOrNumberOrDate } from '../models/chart-data.model';
import { PlacementTypes } from '../common/tooltip/position';
import { StyleTypes } from '../common/tooltip/style.type';
import { ColorHelper } from '../common/color.helper';
import { BarChartType } from './types/bar-chart-type.enum';
import { Bar } from './types/bar.model';
import { ViewDimensions } from '../common/types/view-dimension.interface';
import { BarOrientation } from '../common/types/bar-orientation.enum';
import * as i0 from "@angular/core";
export declare class SeriesVerticalComponent implements OnChanges {
    private platformId;
    dims: ViewDimensions;
    type: BarChartType;
    series: DataItem[];
    xScale: any;
    yScale: any;
    colors: ColorHelper;
    gradient: boolean;
    activeEntries: DataItem[];
    seriesName: StringOrNumberOrDate;
    tooltipDisabled: boolean;
    tooltipTemplate: TemplateRef<any>;
    roundEdges: boolean;
    animations: boolean;
    showDataLabel: boolean;
    dataLabelFormatting: any;
    noBarWhenZero: boolean;
    select: EventEmitter<DataItem>;
    activate: EventEmitter<any>;
    deactivate: EventEmitter<any>;
    dataLabelHeightChanged: EventEmitter<any>;
    tooltipPlacement: PlacementTypes;
    tooltipType: StyleTypes;
    bars: Bar[];
    barsForDataLabels: Array<{
        x: number;
        y: number;
        width: number;
        height: number;
        total: number;
        series: string;
    }>;
    barOrientation: typeof BarOrientation;
    isSSR: boolean;
    constructor(platformId: any);
    ngOnInit(): void;
    ngOnChanges(changes: any): void;
    update(): void;
    updateDataLabels(): void;
    updateTooltipSettings(): void;
    isActive(entry: DataItem): boolean;
    onClick(data: DataItem): void;
    getLabel(dataItem: DataItem): StringOrNumberOrDate;
    trackBy(index: number, bar: Bar): string;
    trackDataLabelBy(index: number, barLabel: any): string;
    static ɵfac: i0.ɵɵFactoryDeclaration<SeriesVerticalComponent, never>;
    static ɵcmp: i0.ɵɵComponentDeclaration<SeriesVerticalComponent, "g[ngx-charts-series-vertical]", never, { "dims": "dims"; "type": "type"; "series": "series"; "xScale": "xScale"; "yScale": "yScale"; "colors": "colors"; "gradient": "gradient"; "activeEntries": "activeEntries"; "seriesName": "seriesName"; "tooltipDisabled": "tooltipDisabled"; "tooltipTemplate": "tooltipTemplate"; "roundEdges": "roundEdges"; "animations": "animations"; "showDataLabel": "showDataLabel"; "dataLabelFormatting": "dataLabelFormatting"; "noBarWhenZero": "noBarWhenZero"; }, { "select": "select"; "activate": "activate"; "deactivate": "deactivate"; "dataLabelHeightChanged": "dataLabelHeightChanged"; }, never, never>;
}
