import * as d3_color from 'd3-color';
/**
 * Converts a hex to RGB
 *
 * @export
 */
export function hexToRgb(value) {
    // deprecated, use d3.color()
    return d3_color.rgb(value);
}
/**
 * Accepts a color (string) and returns a inverted hex color (string)
 * http://stackoverflow.com/questions/9600295/automatically-change-text-color-to-assure-readability
 *
 * @export
 */
export function invertColor(value) {
    const color = d3_color.rgb(value);
    const { r, g, b, opacity } = color;
    if (opacity === 0) {
        return color.toString();
    }
    const yiq = (r * 299 + g * 587 + b * 114) / 1000;
    const depth = yiq >= 128 ? -0.8 : 0.8;
    return shadeRGBColor(color, depth);
}
/**
 * Given a rgb, it will darken/lighten
 * http://stackoverflow.com/questions/5560248/programmatically-lighten-or-darken-a-hex-color-or-rgb-and-blend-colors
 *
 * @export
 * @param \{ r, g, b }
 */
export function shadeRGBColor({ r, g, b }, percent) {
    const t = percent < 0 ? 0 : 255;
    const p = percent < 0 ? percent * -1 : percent;
    r = Math.round((t - r) * p) + r;
    g = Math.round((t - g) * p) + g;
    b = Math.round((t - b) * p) + b;
    return `rgb(${r}, ${g}, ${b})`;
}
//# sourceMappingURL=data:application/json;base64,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