import { ScaleType } from '../common/types/scale-type.enum';
export let colorSets = [
    {
        name: 'vivid',
        selectable: true,
        group: ScaleType.Ordinal,
        domain: [
            '#647c8a',
            '#3f51b5',
            '#2196f3',
            '#00b862',
            '#afdf0a',
            '#a7b61a',
            '#f3e562',
            '#ff9800',
            '#ff5722',
            '#ff4514'
        ]
    },
    {
        name: 'natural',
        selectable: true,
        group: ScaleType.Ordinal,
        domain: [
            '#bf9d76',
            '#e99450',
            '#d89f59',
            '#f2dfa7',
            '#a5d7c6',
            '#7794b1',
            '#afafaf',
            '#707160',
            '#ba9383',
            '#d9d5c3'
        ]
    },
    {
        name: 'cool',
        selectable: true,
        group: ScaleType.Ordinal,
        domain: [
            '#a8385d',
            '#7aa3e5',
            '#a27ea8',
            '#aae3f5',
            '#adcded',
            '#a95963',
            '#8796c0',
            '#7ed3ed',
            '#50abcc',
            '#ad6886'
        ]
    },
    {
        name: 'fire',
        selectable: true,
        group: ScaleType.Ordinal,
        domain: ['#ff3d00', '#bf360c', '#ff8f00', '#ff6f00', '#ff5722', '#e65100', '#ffca28', '#ffab00']
    },
    {
        name: 'solar',
        selectable: true,
        group: ScaleType.Linear,
        domain: [
            '#fff8e1',
            '#ffecb3',
            '#ffe082',
            '#ffd54f',
            '#ffca28',
            '#ffc107',
            '#ffb300',
            '#ffa000',
            '#ff8f00',
            '#ff6f00'
        ]
    },
    {
        name: 'air',
        selectable: true,
        group: ScaleType.Linear,
        domain: [
            '#e1f5fe',
            '#b3e5fc',
            '#81d4fa',
            '#4fc3f7',
            '#29b6f6',
            '#03a9f4',
            '#039be5',
            '#0288d1',
            '#0277bd',
            '#01579b'
        ]
    },
    {
        name: 'aqua',
        selectable: true,
        group: ScaleType.Linear,
        domain: [
            '#e0f7fa',
            '#b2ebf2',
            '#80deea',
            '#4dd0e1',
            '#26c6da',
            '#00bcd4',
            '#00acc1',
            '#0097a7',
            '#00838f',
            '#006064'
        ]
    },
    {
        name: 'flame',
        selectable: false,
        group: ScaleType.Ordinal,
        domain: [
            '#A10A28',
            '#D3342D',
            '#EF6D49',
            '#FAAD67',
            '#FDDE90',
            '#DBED91',
            '#A9D770',
            '#6CBA67',
            '#2C9653',
            '#146738'
        ]
    },
    {
        name: 'ocean',
        selectable: false,
        group: ScaleType.Ordinal,
        domain: [
            '#1D68FB',
            '#33C0FC',
            '#4AFFFE',
            '#AFFFFF',
            '#FFFC63',
            '#FDBD2D',
            '#FC8A25',
            '#FA4F1E',
            '#FA141B',
            '#BA38D1'
        ]
    },
    {
        name: 'forest',
        selectable: false,
        group: ScaleType.Ordinal,
        domain: [
            '#55C22D',
            '#C1F33D',
            '#3CC099',
            '#AFFFFF',
            '#8CFC9D',
            '#76CFFA',
            '#BA60FB',
            '#EE6490',
            '#C42A1C',
            '#FC9F32'
        ]
    },
    {
        name: 'horizon',
        selectable: false,
        group: ScaleType.Ordinal,
        domain: [
            '#2597FB',
            '#65EBFD',
            '#99FDD0',
            '#FCEE4B',
            '#FEFCFA',
            '#FDD6E3',
            '#FCB1A8',
            '#EF6F7B',
            '#CB96E8',
            '#EFDEE0'
        ]
    },
    {
        name: 'neons',
        selectable: false,
        group: ScaleType.Ordinal,
        domain: [
            '#FF3333',
            '#FF33FF',
            '#CC33FF',
            '#0000FF',
            '#33CCFF',
            '#33FFFF',
            '#33FF66',
            '#CCFF33',
            '#FFCC00',
            '#FF6600'
        ]
    },
    {
        name: 'picnic',
        selectable: false,
        group: ScaleType.Ordinal,
        domain: [
            '#FAC51D',
            '#66BD6D',
            '#FAA026',
            '#29BB9C',
            '#E96B56',
            '#55ACD2',
            '#B7332F',
            '#2C83C9',
            '#9166B8',
            '#92E7E8'
        ]
    },
    {
        name: 'night',
        selectable: false,
        group: ScaleType.Ordinal,
        domain: [
            '#2B1B5A',
            '#501356',
            '#183356',
            '#28203F',
            '#391B3C',
            '#1E2B3C',
            '#120634',
            '#2D0432',
            '#051932',
            '#453080',
            '#75267D',
            '#2C507D',
            '#4B3880',
            '#752F7D',
            '#35547D'
        ]
    },
    {
        name: 'nightLights',
        selectable: false,
        group: ScaleType.Ordinal,
        domain: [
            '#4e31a5',
            '#9c25a7',
            '#3065ab',
            '#57468b',
            '#904497',
            '#46648b',
            '#32118d',
            '#a00fb3',
            '#1052a2',
            '#6e51bd',
            '#b63cc3',
            '#6c97cb',
            '#8671c1',
            '#b455be',
            '#7496c3'
        ]
    }
];
//# sourceMappingURL=data:application/json;base64,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