import { LegendPosition } from './types/legend.model';
import { ScaleType } from './types/scale-type.enum';
export function calculateViewDimensions({ width, height, margins, showXAxis = false, showYAxis = false, xAxisHeight = 0, yAxisWidth = 0, showXLabel = false, showYLabel = false, showLegend = false, legendType = ScaleType.Ordinal, legendPosition = LegendPosition.Right, columns = 12 }) {
    let xOffset = margins[3];
    let chartWidth = width;
    let chartHeight = height - margins[0] - margins[2];
    if (showLegend && legendPosition === LegendPosition.Right) {
        if (legendType === ScaleType.Ordinal) {
            columns -= 2;
        }
        else {
            columns -= 1;
        }
    }
    chartWidth = (chartWidth * columns) / 12;
    chartWidth = chartWidth - margins[1] - margins[3];
    if (showXAxis) {
        chartHeight -= 5;
        chartHeight -= xAxisHeight;
        if (showXLabel) {
            // text height + spacing between axis label and tick labels
            const offset = 25 + 5;
            chartHeight -= offset;
        }
    }
    if (showYAxis) {
        chartWidth -= 5;
        chartWidth -= yAxisWidth;
        xOffset += yAxisWidth;
        xOffset += 10;
        if (showYLabel) {
            // text height + spacing between axis label and tick labels
            const offset = 25 + 5;
            chartWidth -= offset;
            xOffset += offset;
        }
    }
    chartWidth = Math.max(0, chartWidth);
    chartHeight = Math.max(0, chartHeight);
    return {
        width: Math.floor(chartWidth),
        height: Math.floor(chartHeight),
        xOffset: Math.floor(xOffset)
    };
}
//# sourceMappingURL=data:application/json;base64,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