export class InjectionRegisteryService {
    constructor(injectionService) {
        this.injectionService = injectionService;
        this.defaults = {};
        this.components = new Map();
    }
    getByType(type = this.type) {
        return this.components.get(type);
    }
    create(bindings) {
        return this.createByType(this.type, bindings);
    }
    createByType(type, bindings) {
        bindings = this.assignDefaults(bindings);
        const component = this.injectComponent(type, bindings);
        this.register(type, component);
        return component;
    }
    destroy(instance) {
        const compsByType = this.components.get(instance.componentType);
        if (compsByType && compsByType.length) {
            const idx = compsByType.indexOf(instance);
            if (idx > -1) {
                const component = compsByType[idx];
                component.destroy();
                compsByType.splice(idx, 1);
            }
        }
    }
    destroyAll() {
        this.destroyByType(this.type);
    }
    destroyByType(type) {
        const comps = this.components.get(type);
        if (comps && comps.length) {
            let i = comps.length - 1;
            while (i >= 0) {
                this.destroy(comps[i--]);
            }
        }
    }
    injectComponent(type, bindings) {
        return this.injectionService.appendComponent(type, bindings);
    }
    assignDefaults(bindings) {
        const inputs = { ...this.defaults.inputs };
        const outputs = { ...this.defaults.outputs };
        if (!bindings.inputs && !bindings.outputs) {
            bindings = { inputs: bindings };
        }
        if (inputs) {
            bindings.inputs = { ...inputs, ...bindings.inputs };
        }
        if (outputs) {
            bindings.outputs = { ...outputs, ...bindings.outputs };
        }
        return bindings;
    }
    register(type, component) {
        if (!this.components.has(type)) {
            this.components.set(type, []);
        }
        const types = this.components.get(type);
        types.push(component);
    }
}
//# sourceMappingURL=data:application/json;base64,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