import { scaleLinear, scalePoint, scaleTime } from 'd3-scale';
import { ScaleType } from '../common/types/scale-type.enum';
export function getDomain(values, scaleType, autoScale, minVal, maxVal) {
    let domain = [];
    if (scaleType === ScaleType.Linear) {
        values = values.map(v => Number(v));
        if (!autoScale) {
            values.push(0);
        }
    }
    if (scaleType === ScaleType.Time || scaleType === ScaleType.Linear) {
        const min = minVal ? minVal : Math.min(...values);
        const max = maxVal ? maxVal : Math.max(...values);
        domain = [min, max];
    }
    else {
        domain = values;
    }
    return domain;
}
export function getScale(domain, range, scaleType, roundDomains) {
    switch (scaleType) {
        case ScaleType.Time:
            return scaleTime().range(range).domain(domain);
        case ScaleType.Linear: {
            const scale = scaleLinear().range(range).domain(domain);
            if (roundDomains) {
                return scale.nice();
            }
            return scale;
        }
        case ScaleType.Ordinal:
            return scalePoint()
                .range([range[0], range[1]])
                .domain(domain.map(r => r.toString()));
        default:
            return undefined;
    }
}
//# sourceMappingURL=data:application/json;base64,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