"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const devkit_1 = require("@nrwl/devkit");
const utils_1 = require("../../executors/utils");
function setProjectBuildConfig(tree) {
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        let changesMade = false;
        const projects = (0, devkit_1.getProjects)(tree);
        [...projects.entries()].forEach(([projectName, projectConfiguration]) => {
            var _a, _b, _c;
            const { storybookBuildTarget, storybookTarget, buildTarget } = (0, utils_1.findStorybookAndBuildTargets)(projectConfiguration.targets);
            if (projectName &&
                storybookTarget &&
                ((_c = (_b = (_a = projectConfiguration === null || projectConfiguration === void 0 ? void 0 : projectConfiguration.targets) === null || _a === void 0 ? void 0 : _a[storybookTarget]) === null || _b === void 0 ? void 0 : _b.options) === null || _c === void 0 ? void 0 : _c.uiFramework) ===
                    '@storybook/angular') {
                if (buildTarget) {
                    if (!projectConfiguration.targets[storybookTarget].options
                        .projectBuildConfig) {
                        projectConfiguration.targets[storybookTarget].options.projectBuildConfig = projectName;
                        changesMade = true;
                    }
                    if (storybookBuildTarget &&
                        !projectConfiguration.targets[storybookBuildTarget].options
                            .projectBuildConfig) {
                        projectConfiguration.targets[storybookBuildTarget].options.projectBuildConfig = projectName;
                        changesMade = true;
                    }
                }
                else {
                    if (storybookBuildTarget) {
                        if (!projectConfiguration.targets[storybookTarget].options
                            .projectBuildConfig) {
                            projectConfiguration.targets[storybookTarget].options.projectBuildConfig = `${projectName}:${storybookBuildTarget}`;
                            changesMade = true;
                        }
                        if (!projectConfiguration.targets[storybookBuildTarget].options
                            .projectBuildConfig) {
                            projectConfiguration.targets[storybookBuildTarget].options.projectBuildConfig = `${projectName}:${storybookBuildTarget}`;
                            changesMade = true;
                        }
                    }
                    else {
                        devkit_1.logger.warn(`Could not find a build target for ${projectName}.`);
                    }
                }
                if (changesMade) {
                    (0, devkit_1.updateProjectConfiguration)(tree, projectName, projectConfiguration);
                }
            }
        });
        if (changesMade) {
            yield (0, devkit_1.formatFiles)(tree);
        }
    });
}
exports.default = setProjectBuildConfig;
//# sourceMappingURL=set-project-build-config.js.map