"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.cypressProjectSchematic = exports.cypressProjectGenerator = void 0;
const tslib_1 = require("tslib");
const devkit_1 = require("@nrwl/devkit");
const cypress_1 = require("@nrwl/cypress");
const project_name_1 = require("@nrwl/cypress/src/utils/project-name");
const utilities_1 = require("../../utils/utilities");
const run_tasks_in_serial_1 = require("@nrwl/workspace/src/utilities/run-tasks-in-serial");
function cypressProjectGenerator(tree, schema) {
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        const libConfig = (0, devkit_1.readProjectConfiguration)(tree, schema.name);
        const libRoot = libConfig.root;
        const cypressProjectName = `${schema.directory ? (0, project_name_1.getUnscopedLibName)(libRoot) : schema.name}-e2e`;
        const tasks = [];
        if (!projectAlreadyHasCypress(tree)) {
            tasks.push((0, cypress_1.cypressInitGenerator)(tree, {}));
        }
        const installTask = yield (0, cypress_1.cypressProjectGenerator)(tree, {
            name: cypressProjectName,
            project: schema.name,
            js: schema.js,
            linter: schema.linter,
            directory: schema.directory,
            standaloneConfig: schema.standaloneConfig,
        });
        tasks.push(installTask);
        const generatedCypressProjectName = (0, project_name_1.getE2eProjectName)(schema.name, libRoot, schema.directory);
        removeUnneededFiles(tree, generatedCypressProjectName, schema.js);
        addBaseUrlToCypressConfig(tree, generatedCypressProjectName);
        updateAngularJsonBuilder(tree, generatedCypressProjectName, schema.name);
        yield (0, devkit_1.formatFiles)(tree);
        return (0, run_tasks_in_serial_1.runTasksInSerial)(...tasks);
    });
}
exports.cypressProjectGenerator = cypressProjectGenerator;
function removeUnneededFiles(tree, projectName, js) {
    const { sourceRoot } = (0, devkit_1.readProjectConfiguration)(tree, projectName);
    const fileType = js ? 'js' : 'ts';
    (0, utilities_1.safeFileDelete)(tree, `${sourceRoot}/integration/app.spec.${fileType}`);
    (0, utilities_1.safeFileDelete)(tree, `${sourceRoot}/support/app.po.${fileType}`);
}
function addBaseUrlToCypressConfig(tree, projectName) {
    const cypressConfigPath = `${(0, devkit_1.readProjectConfiguration)(tree, projectName).root}/cypress.json`;
    (0, devkit_1.updateJson)(tree, cypressConfigPath, (cypressConfig) => {
        cypressConfig.baseUrl = 'http://localhost:4400';
        return cypressConfig;
    });
}
function updateAngularJsonBuilder(tree, e2eProjectName, targetProjectName) {
    const project = (0, devkit_1.readProjectConfiguration)(tree, e2eProjectName);
    const e2eTarget = project.targets.e2e;
    project.targets.e2e = Object.assign(Object.assign({}, e2eTarget), { options: Object.assign(Object.assign({}, e2eTarget.options), { devServerTarget: `${targetProjectName}:storybook` }), configurations: {
            ci: {
                devServerTarget: `${targetProjectName}:storybook:ci`,
            },
        } });
    (0, devkit_1.updateProjectConfiguration)(tree, e2eProjectName, project);
}
function projectAlreadyHasCypress(tree) {
    var _a, _b, _c, _d;
    const packageJsonContents = (0, devkit_1.readJson)(tree, 'package.json');
    return ((((_a = packageJsonContents === null || packageJsonContents === void 0 ? void 0 : packageJsonContents['devDependencies']) === null || _a === void 0 ? void 0 : _a['@nrwl/cypress']) ||
        ((_b = packageJsonContents === null || packageJsonContents === void 0 ? void 0 : packageJsonContents['dependencies']) === null || _b === void 0 ? void 0 : _b['@nrwl/cypress'])) &&
        (((_c = packageJsonContents === null || packageJsonContents === void 0 ? void 0 : packageJsonContents['devDependencies']) === null || _c === void 0 ? void 0 : _c['cypress']) ||
            ((_d = packageJsonContents === null || packageJsonContents === void 0 ? void 0 : packageJsonContents['dependencies']) === null || _d === void 0 ? void 0 : _d['cypress'])));
}
exports.default = cypressProjectGenerator;
exports.cypressProjectSchematic = (0, devkit_1.convertNxGenerator)(cypressProjectGenerator);
//# sourceMappingURL=cypress-project.js.map