import { Tree } from '@angular-devkit/schematics';
/**
 * Add a property to the jest config
 * @param host
 * @param path - path to the jest config file
 * @param propertyName - Property to update. Can be dot delimited to access deeply nested properties
 * @param value
 */
export declare function addPropertyToJestConfig(host: Tree, path: string, propertyName: string, value: unknown): void;
/**
 * Remove a property value from the jest config
 * @param host
 * @param path
 * @param propertyName - Property to remove. Can be dot delimited to access deeply nested properties
 */
export declare function removePropertyFromJestConfig(host: Tree, path: string, propertyName: string): void;
