"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.updateJestConfig = void 0;
const update_config_1 = require("../../../utils/config/update-config");
const devkit_1 = require("@nrwl/devkit");
function isUsingUtilityFunction(host) {
    return host.read('jest.config.js').toString().includes('getJestProjects()');
}
function updateJestConfig(host, options) {
    if (isUsingUtilityFunction(host)) {
        return;
    }
    const project = (0, devkit_1.readProjectConfiguration)(host, options.project);
    (0, update_config_1.addPropertyToJestConfig)(host, 'jest.config.js', 'projects', `<rootDir>/${project.root}`);
}
exports.updateJestConfig = updateJestConfig;
//# sourceMappingURL=update-jestconfig.js.map