declare const _default: {
    settings: {
        react: {
            version: string;
        };
    };
    plugins: string[];
    extends: string[];
    rules: {
        /**
         * React-specific rule configurations
         * https://github.com/yannickcr/eslint-plugin-react
         */
        'react/forbid-foreign-prop-types': (string | {
            allowInPropTypes: boolean;
        })[];
        'react/jsx-no-comment-textnodes': string;
        'react/jsx-no-duplicate-props': string;
        'react/jsx-no-target-blank': string;
        'react/jsx-no-undef': string;
        'react/jsx-pascal-case': (string | {
            allowAllCaps: boolean;
            ignore: any[];
        })[];
        'react/jsx-uses-vars': string;
        'react/no-danger-with-children': string;
        'react/no-direct-mutation-state': string;
        'react/no-is-mounted': string;
        'react/no-typos': string;
        'react/jsx-uses-react': string;
        'react/react-in-jsx-scope': string;
        'react/require-render-return': string;
        'react/style-prop-object': string;
        'react/jsx-no-useless-fragment': string;
        /**
         * JSX Accessibility rule configurations
         * https://github.com/evcohen/eslint-plugin-jsx-a11y
         */
        'jsx-a11y/accessible-emoji': string;
        'jsx-a11y/alt-text': string;
        'jsx-a11y/anchor-has-content': string;
        'jsx-a11y/anchor-is-valid': (string | {
            aspects: string[];
        })[];
        'jsx-a11y/aria-activedescendant-has-tabindex': string;
        'jsx-a11y/aria-props': string;
        'jsx-a11y/aria-proptypes': string;
        'jsx-a11y/aria-role': string;
        'jsx-a11y/aria-unsupported-elements': string;
        'jsx-a11y/heading-has-content': string;
        'jsx-a11y/iframe-has-title': string;
        'jsx-a11y/img-redundant-alt': string;
        'jsx-a11y/no-access-key': string;
        'jsx-a11y/no-distracting-elements': string;
        'jsx-a11y/no-redundant-roles': string;
        'jsx-a11y/role-has-required-aria-props': string;
        'jsx-a11y/role-supports-aria-props': string;
        'jsx-a11y/scope': string;
    };
};
/**
 * This configuration is intended to be applied to ONLY files which contain JSX/TSX
 * code.
 *
 * It should therefore NOT contain any rules or plugins which are generic
 * to all file types within variants of React projects.
 *
 * This configuration is intended to be combined with other configs from this
 * package.
 */
export default _default;
