declare const _default: {
    plugins: string[];
    env: {
        browser: boolean;
        commonjs: boolean;
        es6: boolean;
        jest: boolean;
        node: boolean;
    };
    rules: {
        /**
         * Standard ESLint rule configurations
         * https://eslint.org/docs/rules
         */
        'array-callback-return': string;
        'dot-location': string[];
        eqeqeq: string[];
        'new-parens': string;
        'no-caller': string;
        'no-cond-assign': string[];
        'no-const-assign': string;
        'no-control-regex': string;
        'no-delete-var': string;
        'no-dupe-args': string;
        'no-dupe-keys': string;
        'no-duplicate-case': string;
        'no-empty-character-class': string;
        'no-empty-pattern': string;
        'no-eval': string;
        'no-ex-assign': string;
        'no-extend-native': string;
        'no-extra-bind': string;
        'no-extra-label': string;
        'no-fallthrough': string;
        'no-func-assign': string;
        'no-implied-eval': string;
        'no-invalid-regexp': string;
        'no-iterator': string;
        'no-label-var': string;
        'no-labels': (string | {
            allowLoop: boolean;
            allowSwitch: boolean;
        })[];
        'no-lone-blocks': string;
        'no-loop-func': string;
        'no-mixed-operators': (string | {
            groups: string[][];
            allowSamePrecedence: boolean;
        })[];
        'no-multi-str': string;
        'no-native-reassign': string;
        'no-negated-in-lhs': string;
        'no-new-func': string;
        'no-new-object': string;
        'no-new-symbol': string;
        'no-new-wrappers': string;
        'no-obj-calls': string;
        'no-octal': string;
        'no-octal-escape': string;
        'no-redeclare': string;
        'no-regex-spaces': string;
        'no-restricted-syntax': string[];
        'no-script-url': string;
        'no-self-assign': string;
        'no-self-compare': string;
        'no-sequences': string;
        'no-shadow-restricted-names': string;
        'no-sparse-arrays': string;
        'no-template-curly-in-string': string;
        'no-this-before-super': string;
        'no-throw-literal': string;
        'no-restricted-globals': string[];
        'no-unexpected-multiline': string;
        'no-unreachable': string;
        'no-unused-expressions': string;
        'no-unused-labels': string;
        'no-useless-computed-key': string;
        'no-useless-concat': string;
        'no-useless-escape': string;
        'no-useless-rename': (string | {
            ignoreDestructuring: boolean;
            ignoreImport: boolean;
            ignoreExport: boolean;
        })[];
        'no-with': string;
        'no-whitespace-before-property': string;
        'require-yield': string;
        'rest-spread-spacing': string[];
        strict: string[];
        'unicode-bom': string[];
        'use-isnan': string;
        'valid-typeof': string;
        'no-restricted-properties': (string | {
            object: string;
            property: string;
            message: string;
        })[];
        'getter-return': string;
        /**
         * Import rule configurations
         * https://github.com/benmosher/eslint-plugin-import
         */
        'import/first': string;
        'import/no-amd': string;
        'import/no-webpack-loader-syntax': string;
    };
};
/**
 * Rule set originally adapted from:
 * https://github.com/facebook/create-react-app/blob/567f36c9235f1e1fd4a76dc6d1ae00be754ca047/packages/eslint-config-react-app/index.js
 */
export default _default;
