"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.cypressProjectSchematic = exports.cypressProjectGenerator = exports.addLinter = void 0;
const tslib_1 = require("tslib");
const devkit_1 = require("@nrwl/devkit");
const linter_1 = require("@nrwl/linter");
const run_tasks_in_serial_1 = require("@nrwl/workspace/src/utilities/run-tasks-in-serial");
const typescript_1 = require("@nrwl/workspace/src/utilities/typescript");
const path_1 = require("path");
const versions_1 = require("../../utils/versions");
const project_name_1 = require("../../utils/project-name");
const cypress_version_1 = require("../../utils/cypress-version");
function createFiles(tree, options) {
    (0, devkit_1.generateFiles)(tree, (0, path_1.join)(__dirname, './files'), options.projectRoot, Object.assign(Object.assign({ tmpl: '' }, options), { project: options.project || 'Project', ext: options.js ? 'js' : 'ts', offsetFromRoot: (0, devkit_1.offsetFromRoot)(options.projectRoot), rootTsConfigPath: (0, typescript_1.getRelativePathToRootTsConfig)(tree, options.projectRoot) }));
    const cypressVersion = (0, cypress_version_1.installedCypressVersion)();
    if (!cypressVersion || cypressVersion >= 7) {
        tree.delete((0, path_1.join)(options.projectRoot, 'src/plugins/index.js'));
    }
    else {
        (0, devkit_1.updateJson)(tree, (0, path_1.join)(options.projectRoot, 'cypress.json'), (json) => {
            json.pluginsFile = './src/plugins/index';
            return json;
        });
    }
    if (options.js) {
        (0, devkit_1.toJS)(tree);
    }
}
function addProject(tree, options) {
    var _a, _b, _c, _d;
    let e2eProjectConfig;
    if (options.baseUrl) {
        e2eProjectConfig = {
            root: options.projectRoot,
            sourceRoot: (0, devkit_1.joinPathFragments)(options.projectRoot, 'src'),
            projectType: 'application',
            targets: {
                e2e: {
                    executor: '@nrwl/cypress:cypress',
                    options: {
                        cypressConfig: (0, devkit_1.joinPathFragments)(options.projectRoot, 'cypress.json'),
                        baseUrl: options.baseUrl,
                    },
                },
            },
            tags: [],
            implicitDependencies: options.project ? [options.project] : undefined,
        };
    }
    else if (options.project) {
        const project = (0, devkit_1.readProjectConfiguration)(tree, options.project);
        if (!project.targets) {
            devkit_1.logger.warn((0, devkit_1.stripIndents) `
      NOTE: Project, "${options.project}", does not have any targets defined and a baseUrl was not provided. Nx will use  
      "${options.project}:serve" as the devServerTarget. But you may need to define this target within the project, "${options.project}".
      `);
        }
        const devServerTarget = ((_a = project.targets) === null || _a === void 0 ? void 0 : _a.serve) && ((_c = (_b = project.targets) === null || _b === void 0 ? void 0 : _b.serve) === null || _c === void 0 ? void 0 : _c.defaultConfiguration)
            ? `${options.project}:serve:${project.targets.serve.defaultConfiguration}`
            : `${options.project}:serve`;
        e2eProjectConfig = {
            root: options.projectRoot,
            sourceRoot: (0, devkit_1.joinPathFragments)(options.projectRoot, 'src'),
            projectType: 'application',
            targets: {
                e2e: {
                    executor: '@nrwl/cypress:cypress',
                    options: {
                        cypressConfig: (0, devkit_1.joinPathFragments)(options.projectRoot, 'cypress.json'),
                        devServerTarget,
                    },
                    configurations: {
                        production: {
                            devServerTarget: `${options.project}:serve:production`,
                        },
                    },
                },
            },
            tags: [],
            implicitDependencies: options.project ? [options.project] : undefined,
        };
    }
    else {
        throw new Error(`Either project or baseUrl should be specified.`);
    }
    const detectedCypressVersion = (_d = (0, cypress_version_1.installedCypressVersion)()) !== null && _d !== void 0 ? _d : versions_1.cypressVersion;
    if (detectedCypressVersion < 7) {
        e2eProjectConfig.targets.e2e.options.tsConfig = (0, devkit_1.joinPathFragments)(options.projectRoot, 'tsconfig.json');
    }
    (0, devkit_1.addProjectConfiguration)(tree, options.projectName, e2eProjectConfig, options.standaloneConfig);
}
function addLinter(host, options) {
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        if (options.linter === linter_1.Linter.None) {
            return () => { };
        }
        const installTask = yield (0, linter_1.lintProjectGenerator)(host, {
            project: options.projectName,
            linter: options.linter,
            skipFormat: true,
            tsConfigPaths: [(0, devkit_1.joinPathFragments)(options.projectRoot, 'tsconfig.json')],
            eslintFilePatterns: [
                `${options.projectRoot}/**/*.${options.js ? 'js' : '{js,ts}'}`,
            ],
            setParserOptionsProject: options.setParserOptionsProject,
            skipPackageJson: options.skipPackageJson,
        });
        if (!options.linter || options.linter !== linter_1.Linter.EsLint) {
            return installTask;
        }
        const installTask2 = !options.skipPackageJson
            ? (0, devkit_1.addDependenciesToPackageJson)(host, {}, { 'eslint-plugin-cypress': versions_1.eslintPluginCypressVersion })
            : () => { };
        (0, devkit_1.updateJson)(host, (0, path_1.join)(options.projectRoot, '.eslintrc.json'), (json) => {
            json.extends = ['plugin:cypress/recommended', ...json.extends];
            json.overrides = [
                /**
                 * In order to ensure maximum efficiency when typescript-eslint generates TypeScript Programs
                 * behind the scenes during lint runs, we need to make sure the project is configured to use its
                 * own specific tsconfigs, and not fall back to the ones in the root of the workspace.
                 */
                {
                    files: ['*.ts', '*.tsx', '*.js', '*.jsx'],
                    /**
                     * NOTE: We no longer set parserOptions.project by default when creating new projects.
                     *
                     * We have observed that users rarely add rules requiring type-checking to their Nx workspaces, and therefore
                     * do not actually need the capabilites which parserOptions.project provides. When specifying parserOptions.project,
                     * typescript-eslint needs to create full TypeScript Programs for you. When omitting it, it can perform a simple
                     * parse (and AST tranformation) of the source files it encounters during a lint run, which is much faster and much
                     * less memory intensive.
                     *
                     * In the rare case that users attempt to add rules requiring type-checking to their setup later on (and haven't set
                     * parserOptions.project), the executor will attempt to look for the particular error typescript-eslint gives you
                     * and provide feedback to the user.
                     */
                    parserOptions: !options.setParserOptionsProject
                        ? undefined
                        : {
                            project: `${options.projectRoot}/tsconfig.*?.json`,
                        },
                    /**
                     * Having an empty rules object present makes it more obvious to the user where they would
                     * extend things from if they needed to
                     */
                    rules: {},
                },
            ];
            if ((0, cypress_version_1.installedCypressVersion)() < 7) {
                /**
                 * We need this override because we enabled allowJS in the tsconfig to allow for JS based Cypress tests.
                 * That however leads to issues with the CommonJS Cypress plugin file.
                 */
                json.overrides.push({
                    files: ['src/plugins/index.js'],
                    rules: {
                        '@typescript-eslint/no-var-requires': 'off',
                        'no-undef': 'off',
                    },
                });
            }
            return json;
        });
        return (0, run_tasks_in_serial_1.runTasksInSerial)(installTask, installTask2);
    });
}
exports.addLinter = addLinter;
function cypressProjectGenerator(host, schema) {
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        const options = normalizeOptions(host, schema);
        createFiles(host, options);
        addProject(host, options);
        const installTask = yield addLinter(host, options);
        if (!options.skipFormat) {
            yield (0, devkit_1.formatFiles)(host);
        }
        return installTask;
    });
}
exports.cypressProjectGenerator = cypressProjectGenerator;
function normalizeOptions(host, options) {
    const { appsDir } = (0, devkit_1.getWorkspaceLayout)(host);
    const projectName = (0, project_name_1.filePathPrefix)(options.directory ? `${options.directory}-${options.name}` : options.name);
    const projectRoot = options.directory
        ? (0, devkit_1.joinPathFragments)(appsDir, (0, devkit_1.names)(options.directory).fileName, options.name)
        : (0, devkit_1.joinPathFragments)(appsDir, options.name);
    options.linter = options.linter || linter_1.Linter.EsLint;
    return Object.assign(Object.assign({}, options), { projectName,
        projectRoot });
}
exports.default = cypressProjectGenerator;
exports.cypressProjectSchematic = (0, devkit_1.convertNxGenerator)(cypressProjectGenerator);
//# sourceMappingURL=cypress-project.js.map