import 'dotenv/config';
import { ExecutorContext } from '@nrwl/devkit';
export declare type Json = {
    [k: string]: any;
};
export interface CypressExecutorOptions extends Json {
    cypressConfig: string;
    watch?: boolean;
    tsConfig?: string;
    devServerTarget?: string;
    headed?: boolean;
    headless?: boolean;
    exit?: boolean;
    key?: string;
    record?: boolean;
    parallel?: boolean;
    baseUrl?: string;
    browser?: string;
    env?: Record<string, string>;
    spec?: string;
    copyFiles?: string;
    ciBuildId?: string | number;
    group?: string;
    ignoreTestFiles?: string;
    reporter?: string;
    reporterOptions?: string;
    skipServe?: boolean;
    testingType?: 'component' | 'e2e';
    tag?: string;
}
export default function cypressExecutor(options: CypressExecutorOptions, context: ExecutorContext): Promise<{
    success: any;
}>;
