"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.readFirst = exports.readAll = void 0;
const operators_1 = require("rxjs/operators");
/**
 * @whatItDoes reads all the values from an observable and returns a promise
 * with an array of all values. This should be used in combination with async/await.
 *
 * ## Example
 *
 * ```typescript
 * const obs = of(1, 2, 3, 4);
 * const res = await readAll(obs)
 * expect(res).toEqual([1, 2, 3, 4]);
 * ```
 */
function readAll(o) {
    return o.pipe((0, operators_1.toArray)()).toPromise();
}
exports.readAll = readAll;
/**
 * @whatItDoes reads the first value from an observable and returns a promise
 * with it. This should be used in combination with async/await.
 *
 * ## Example
 *
 * ```typescript
 * const obs = of(1, 2, 3, 4);
 * const res = await readFirst(obs)
 * expect(res).toEqual(1);
 * ```
 */
function readFirst(o) {
    return o.pipe((0, operators_1.first)()).toPromise();
}
exports.readFirst = readFirst;
//# sourceMappingURL=testing-utils.js.map