"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.callRule = exports.runMigration = void 0;
const path_1 = require("path");
const testing_1 = require("@angular-devkit/schematics/testing");
const testRunner = new testing_1.SchematicTestRunner('@nrwl/angular', (0, path_1.join)(__dirname, '../../generators.json'));
testRunner.registerCollection('@nrwl/jest', (0, path_1.join)(__dirname, '../../../jest/generators.json'));
testRunner.registerCollection('@nrwl/workspace', (0, path_1.join)(__dirname, '../../../workspace/generators.json'));
testRunner.registerCollection('@nrwl/cypress', (0, path_1.join)(__dirname, '../../../cypress/generators.json'));
testRunner.registerCollection('@nrwl/storybook', (0, path_1.join)(__dirname, '../../../storybook/generators.json'));
const migrationTestRunner = new testing_1.SchematicTestRunner('@nrwl/workspace', (0, path_1.join)(__dirname, '../../migrations.json'));
function runMigration(schematicName, options, tree) {
    return migrationTestRunner
        .runSchematicAsync(schematicName, options, tree)
        .toPromise();
}
exports.runMigration = runMigration;
function callRule(rule, tree) {
    return testRunner.callRule(rule, tree).toPromise();
}
exports.callRule = callRule;
//# sourceMappingURL=testing.js.map