"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createLib = exports.createApp = exports.getLibConfig = exports.getAppConfig = void 0;
const devkit_1 = require("@nrwl/devkit");
var appConfig; // configure built in createApp()
var libConfig;
function getAppConfig() {
    return appConfig;
}
exports.getAppConfig = getAppConfig;
function getLibConfig() {
    return libConfig;
}
exports.getLibConfig = getLibConfig;
function createApp(tree, appName, routing = true) {
    appName = (0, devkit_1.names)(appName).fileName;
    // save for getAppDir() lookup by external *.spec.ts tests
    appConfig = {
        appName,
        appModule: `/apps/${appName}/src/app/app.module.ts`,
    };
    tree.write(appConfig.appModule, `
     import { NgModule } from '@angular/core';
     import { BrowserModule } from '@angular/platform-browser';
     ${routing ? "import { RouterModule } from '@angular/router'" : ''};
     import { AppComponent } from './app.component';
     @NgModule({
       imports: [BrowserModule, ${routing ? 'RouterModule.forRoot([])' : ''}],
       declarations: [AppComponent],
       bootstrap: [AppComponent]
     })
     export class AppModule {}
  `);
    tree.write(`/apps/${appName}/src/main.ts`, `
    import { enableProdMode } from '@angular/core';
    import { platformBrowserDynamic } from '@angular/platform-browser-dynamic';

    import { AppModule } from './app/app.module';
    import { environment } from './environments/environment';

    if (environment.production) {
      enableProdMode();
    }

    platformBrowserDynamic()
      .bootstrapModule(AppModule)
      .catch(err => console.log(err));
  `);
    tree.write(`/apps/${appName}/tsconfig.app.json`, JSON.stringify({
        include: ['**/*.ts'],
    }));
    tree.write(`/apps/${appName}-e2e/tsconfig.e2e.json`, JSON.stringify({
        include: ['../**/*.ts'],
    }));
    tree.write('/workspace.json', JSON.stringify({
        newProjectRoot: '',
        version: 1,
        projects: {
            [appName]: {
                root: `apps/${appName}`,
                sourceRoot: `apps/${appName}/src`,
                architect: {
                    build: {
                        options: {
                            main: `apps/${appName}/src/main.ts`,
                        },
                    },
                    serve: {
                        options: {},
                    },
                },
                tags: [],
            },
        },
    }));
}
exports.createApp = createApp;
function createLib(tree, libName) {
    const { name, className, fileName, propertyName } = (0, devkit_1.names)(libName);
    libConfig = {
        name,
        module: `/libs/${propertyName}/src/lib/${fileName}.module.ts`,
        barrel: `/libs/${propertyName}/src/index.ts`,
    };
    tree.write(libConfig.module, `
      import { NgModule } from '@angular/core';
      import { CommonModule } from '@angular/common';
      @NgModule({
        imports: [
          CommonModule
        ],
        providers: []
      })
      export class ${className}Module { }
  `);
    tree.write(libConfig.barrel, `
    export * from './lib/${fileName}.module';
  `);
}
exports.createLib = createLib;
//# sourceMappingURL=testing.js.map