"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.withModuleFederation = void 0;
const tslib_1 = require("tslib");
const mfe_webpack_1 = require("./mfe-webpack");
const devkit_1 = require("@nrwl/devkit");
const typescript_1 = require("@nrwl/workspace/src/utilities/typescript");
const file_utils_1 = require("nx/src/project-graph/file-utils");
const ModuleFederationPlugin = require("webpack/lib/container/ModuleFederationPlugin");
function recursivelyResolveWorkspaceDependents(projectGraph, target, seenTargets = new Set()) {
    var _a;
    if (seenTargets.has(target)) {
        return [];
    }
    let dependencies = [target];
    seenTargets.add(target);
    const workspaceDependencies = ((_a = projectGraph.dependencies[target]) !== null && _a !== void 0 ? _a : []).filter((dep) => !dep.target.startsWith('npm:'));
    if (workspaceDependencies.length > 0) {
        for (const dep of workspaceDependencies) {
            dependencies = [
                ...dependencies,
                ...recursivelyResolveWorkspaceDependents(projectGraph, dep.target, seenTargets),
            ];
        }
    }
    return dependencies;
}
function mapWorkspaceLibrariesToTsConfigImport(workspaceLibraries) {
    var _a, _b;
    const { projects } = new devkit_1.Workspaces(devkit_1.workspaceRoot).readWorkspaceConfiguration();
    const tsConfigPath = (_a = process.env.NX_TSCONFIG_PATH) !== null && _a !== void 0 ? _a : (0, typescript_1.getRootTsConfigPath)();
    const tsConfig = (0, typescript_1.readTsConfig)(tsConfigPath);
    const tsconfigPathAliases = (_b = tsConfig.options) === null || _b === void 0 ? void 0 : _b.paths;
    if (!tsconfigPathAliases) {
        return workspaceLibraries;
    }
    const mappedLibraries = [];
    for (const lib of workspaceLibraries) {
        const sourceRoot = projects[lib].sourceRoot;
        let found = false;
        for (const [key, value] of Object.entries(tsconfigPathAliases)) {
            if (value.find((p) => p.startsWith(sourceRoot))) {
                mappedLibraries.push(key);
                found = true;
                break;
            }
        }
        if (!found) {
            mappedLibraries.push(lib);
        }
    }
    return mappedLibraries;
}
function getDependentPackagesForProject(name) {
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        let projectGraph;
        try {
            projectGraph = (0, devkit_1.readCachedProjectGraph)();
        }
        catch (e) {
            projectGraph = yield (0, devkit_1.createProjectGraphAsync)();
        }
        const deps = projectGraph.dependencies[name].reduce((dependencies, dependency) => {
            const workspaceLibraries = new Set(dependencies.workspaceLibraries);
            const npmPackages = new Set(dependencies.npmPackages);
            if (dependency.target.startsWith('npm:')) {
                npmPackages.add(dependency.target.replace('npm:', ''));
            }
            else {
                workspaceLibraries.add(dependency.target);
            }
            return {
                workspaceLibraries: [...workspaceLibraries],
                npmPackages: [...npmPackages],
            };
        }, { workspaceLibraries: [], npmPackages: [] });
        const seenWorkspaceLibraries = new Set();
        deps.workspaceLibraries = deps.workspaceLibraries.reduce((workspaceLibraryDeps, workspaceLibrary) => [
            ...workspaceLibraryDeps,
            ...recursivelyResolveWorkspaceDependents(projectGraph, workspaceLibrary, seenWorkspaceLibraries),
        ], []);
        deps.workspaceLibraries = mapWorkspaceLibrariesToTsConfigImport(deps.workspaceLibraries);
        return deps;
    });
}
function determineRemoteUrl(remote) {
    const workspace = (0, file_utils_1.readWorkspaceJson)();
    let publicHost = '';
    try {
        publicHost = workspace.projects[remote].targets.serve.options.publicHost;
    }
    catch (error) {
        throw new Error(`Cannot automatically determine URL of remote (${remote}). Looked for property "publicHost" in the project's "serve" target.\n
      You can also use the tuple syntax in your webpack config to configure your remotes. e.g. \`remotes: [['remote1', 'http://localhost:4201']]\``);
    }
    return `${publicHost.endsWith('/') ? publicHost.slice(0, -1) : publicHost}/remoteEntry.mjs`;
}
function mapRemotes(remotes) {
    const mappedRemotes = {};
    for (const remote of remotes) {
        if (Array.isArray(remote)) {
            const remoteLocation = remote[1].match(/remoteEntry\.(js|mjs)/)
                ? remote[1]
                : `${remote[1].endsWith('/') ? remote[1].slice(0, -1) : remote[1]}/remoteEntry.mjs`;
            mappedRemotes[remote[0]] = remoteLocation;
        }
        else if (typeof remote === 'string') {
            mappedRemotes[remote] = determineRemoteUrl(remote);
        }
    }
    return mappedRemotes;
}
function withModuleFederation(options) {
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        const DEFAULT_NPM_PACKAGES_TO_AVOID = ['zone.js'];
        const dependencies = yield getDependentPackagesForProject(options.name);
        const sharedLibraries = (0, mfe_webpack_1.shareWorkspaceLibraries)(dependencies.workspaceLibraries);
        const npmPackages = (0, mfe_webpack_1.sharePackages)(dependencies.npmPackages.filter((pkg) => !DEFAULT_NPM_PACKAGES_TO_AVOID.includes(pkg)));
        const sharedDependencies = Object.assign(Object.assign({}, sharedLibraries.getLibraries()), npmPackages);
        if (options.shared) {
            for (const [libraryName, library] of Object.entries(sharedDependencies)) {
                const mappedDependency = options.shared(libraryName, library);
                if (mappedDependency === false) {
                    delete sharedDependencies[libraryName];
                    continue;
                }
                else if (!mappedDependency) {
                    continue;
                }
                sharedDependencies[libraryName] = mappedDependency;
            }
        }
        const mappedRemotes = !options.remotes || options.remotes.length === 0
            ? {}
            : mapRemotes(options.remotes);
        return (config) => {
            var _a, _b, _c, _d, _e, _f, _g;
            return (Object.assign(Object.assign({}, (config !== null && config !== void 0 ? config : {})), { output: Object.assign(Object.assign({}, ((_a = config.output) !== null && _a !== void 0 ? _a : {})), { uniqueName: options.name, publicPath: 'auto' }), optimization: Object.assign(Object.assign({}, ((_b = config.optimization) !== null && _b !== void 0 ? _b : {})), { runtimeChunk: false }), resolve: Object.assign(Object.assign({}, ((_c = config.resolve) !== null && _c !== void 0 ? _c : {})), { alias: Object.assign(Object.assign({}, ((_e = (_d = config.resolve) === null || _d === void 0 ? void 0 : _d.alias) !== null && _e !== void 0 ? _e : {})), sharedLibraries.getAliases()) }), experiments: Object.assign(Object.assign({}, ((_f = config.experiments) !== null && _f !== void 0 ? _f : {})), { outputModule: true }), plugins: [
                    ...((_g = config.plugins) !== null && _g !== void 0 ? _g : []),
                    new ModuleFederationPlugin({
                        name: options.name,
                        filename: 'remoteEntry.mjs',
                        exposes: options.exposes,
                        remotes: mappedRemotes,
                        shared: Object.assign({}, sharedDependencies),
                        library: {
                            type: 'module',
                        },
                    }),
                    sharedLibraries.getReplacementPlugin(),
                ] }));
        };
    });
}
exports.withModuleFederation = withModuleFederation;
//# sourceMappingURL=with-module-federation.js.map