"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getMfeProjects = void 0;
const tsquery_1 = require("@phenomnomnominal/tsquery");
const executor_options_utils_1 = require("@nrwl/workspace/src/utilities/executor-options-utils");
function getMfeProjects(tree, { legacy } = { legacy: false }) {
    const NRWL_WEBPACK_BROWSER_BUILDER = '@nrwl/angular:webpack-browser';
    const CUSTOM_WEBPACK_OPTION = 'customWebpackConfig';
    const MODULE_FEDERATION_IDENTIFIER = legacy
        ? 'Identifier[name=ModuleFederationPlugin]'
        : 'Identifier[name=withModuleFederation]';
    const projects = [];
    (0, executor_options_utils_1.forEachExecutorOptions)(tree, NRWL_WEBPACK_BROWSER_BUILDER, (opts, projectName) => {
        var _a;
        const webpackPath = (_a = opts[CUSTOM_WEBPACK_OPTION]) === null || _a === void 0 ? void 0 : _a.path;
        if (!webpackPath || !tree.exists(webpackPath)) {
            return;
        }
        const webpackConfig = tree.read(webpackPath, 'utf-8');
        const ast = tsquery_1.tsquery.ast(webpackConfig);
        const moduleFederationWebpackConfig = (0, tsquery_1.tsquery)(ast, MODULE_FEDERATION_IDENTIFIER, {
            visitAllChildren: true,
        });
        if (!moduleFederationWebpackConfig ||
            moduleFederationWebpackConfig.length === 0) {
            return;
        }
        projects.push(projectName);
    });
    return projects;
}
exports.getMfeProjects = getMfeProjects;
//# sourceMappingURL=get-mfe-projects.js.map