"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const devkit_1 = require("@nrwl/devkit");
function default_1(tree) {
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        const projects = (0, devkit_1.getProjects)(tree);
        for (const [projectName, project] of projects) {
            if (!project.targets) {
                continue;
            }
            let shouldUpdate = false;
            Object.values(project.targets).forEach((target) => {
                if (target.executor === '@nrwl/angular:webpack-browser') {
                    shouldUpdate = true;
                    target.options = Object.assign(Object.assign({}, target.options), { buildLibsFromSource: false });
                }
            });
            if (shouldUpdate) {
                (0, devkit_1.updateProjectConfiguration)(tree, projectName, project);
            }
        }
        yield (0, devkit_1.formatFiles)(tree);
    });
}
exports.default = default_1;
//# sourceMappingURL=set-build-libs-from-source.js.map