"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const devkit_1 = require("@nrwl/devkit");
const executor_options_utils_1 = require("@nrwl/workspace/src/utilities/executor-options-utils");
function default_1(tree) {
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        const executorName = '@angular-devkit/build-angular:karma';
        (0, executor_options_utils_1.forEachExecutorOptions)(tree, executorName, ({ karmaConfig }, projectName) => {
            const project = (0, devkit_1.readProjectConfiguration)(tree, projectName);
            const pathToKarma = (0, devkit_1.joinPathFragments)(project.root, karmaConfig);
            if (!tree.exists(pathToKarma)) {
                return;
            }
            const karmaContents = tree.read(pathToKarma, 'utf-8');
            const updatedKarmaContents = karmaContents.replace(/coverageIstanbulReporter/g, 'coverageReporter');
            tree.write(pathToKarma, updatedKarmaContents);
        });
        const pathToRootKarmaConf = 'karma.conf.js';
        if (!tree.exists(pathToRootKarmaConf)) {
            return;
        }
        const rootKarmaContents = tree.read(pathToRootKarmaConf, 'utf-8');
        const updatedKarmaContents = rootKarmaContents
            .replace(/coverageIstanbulReporter/g, 'coverageReporter')
            .replace(/karma-coverage-istanbul-reporter/, 'karma-coverage')
            .replace(/reports: \[(.+)\]/, `subdir: '.',\nreporters: [{ type: 'html' }, { type: 'text-summary' }]`)
            .replace(/'\.\.\/\.\.\/coverage'/, `'./coverage'`)
            .replace(/fixWebpackSourcePaths: true,/, '');
        tree.write(pathToRootKarmaConf, updatedKarmaContents);
        const installPackages = (0, devkit_1.addDependenciesToPackageJson)(tree, {}, {
            'karma-coverage': '~2.2.0',
        });
        yield (0, devkit_1.formatFiles)(tree);
        return installPackages;
    });
}
exports.default = default_1;
//# sourceMappingURL=migrate-karma-conf.js.map