"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const devkit_1 = require("@nrwl/devkit");
const get_mfe_projects_1 = require("../../utils/get-mfe-projects");
function default_1(tree) {
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        const projects = (0, get_mfe_projects_1.getMfeProjects)(tree);
        for (const project of projects) {
            const e2eProjectName = `${project}-e2e`;
            let e2eProject;
            try {
                e2eProject = (0, devkit_1.readProjectConfiguration)(tree, e2eProjectName);
            }
            catch (_a) {
                continue;
            }
            if (e2eProject.targets.e2e.executor !== '@nrwl/cypress:cypress') {
                // Not a cypress e2e project, skip
                return;
            }
            const commandToAdd = `Cypress.on('uncaught:exception', err => {
        if (err.message.includes(\`Cannot use 'import.meta' outside a module\`)) {
          return false;
        }
        return true;
      });`;
            const pathToCommandsFile = (0, devkit_1.joinPathFragments)(e2eProject.sourceRoot, 'support/index.ts');
            const commandsContent = tree.exists(pathToCommandsFile)
                ? tree.read(pathToCommandsFile, 'utf-8')
                : '';
            tree.write(pathToCommandsFile, `${commandsContent}\n${commandToAdd}`);
        }
        yield (0, devkit_1.formatFiles)(tree);
    });
}
exports.default = default_1;
//# sourceMappingURL=add-cypress-mfe-workaround.js.map