"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.modifyConfigToUseShareHelper = exports.modifyConfigToUseMinimizeOptimization = exports.replaceBrowserModuleWithCommonFromRemoteEntry = void 0;
const tslib_1 = require("tslib");
const devkit_1 = require("@nrwl/devkit");
const tsquery_1 = require("@phenomnomnominal/tsquery");
const executor_options_utils_1 = require("@nrwl/workspace/src/utilities/executor-options-utils");
function default_1(tree) {
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        const NRWL_WEBPACK_BROWSER_BUILDER = '@nrwl/angular:webpack-browser';
        const CUSTOM_WEBPACK_OPTION = 'customWebpackConfig';
        const projects = {};
        (0, executor_options_utils_1.forEachExecutorOptions)(tree, NRWL_WEBPACK_BROWSER_BUILDER, (opts, projectName) => {
            var _a;
            // Update the webpack config
            const webpackPath = (_a = opts[CUSTOM_WEBPACK_OPTION]) === null || _a === void 0 ? void 0 : _a.path;
            if (!webpackPath || !tree.exists(webpackPath)) {
                return;
            }
            const webpackConfig = tree.read(webpackPath, 'utf-8');
            const ast = tsquery_1.tsquery.ast(webpackConfig);
            const moduleFederationWebpackConfig = (0, tsquery_1.tsquery)(ast, 'Identifier[name=ModuleFederationPlugin]', {
                visitAllChildren: true,
            });
            if (!moduleFederationWebpackConfig ||
                moduleFederationWebpackConfig.length === 0) {
                return;
            }
            projects[projectName] = webpackPath;
        });
        useShareHelper(tree, projects);
        turnMinimizeOn(tree, projects);
        switchToES2020(tree, projects);
        replaceBrowserModuleInRemoteEntry(tree, projects);
        yield (0, devkit_1.formatFiles)(tree);
    });
}
exports.default = default_1;
function replaceBrowserModuleInRemoteEntry(tree, projects) {
    for (const projectName of Object.keys(projects)) {
        const remoteEntryModulePath = (0, devkit_1.joinPathFragments)((0, devkit_1.readProjectConfiguration)(tree, projectName).sourceRoot, `app/remote-entry/entry.module.ts`);
        if (!tree.exists(remoteEntryModulePath)) {
            continue;
        }
        let remoteEntryModuleContents = tree.read(remoteEntryModulePath, 'utf-8');
        remoteEntryModuleContents = replaceBrowserModuleWithCommonFromRemoteEntry(remoteEntryModuleContents);
        tree.write(remoteEntryModulePath, remoteEntryModuleContents);
    }
}
function replaceBrowserModuleWithCommonFromRemoteEntry(remoteEntryModule) {
    const IS_BROWSER_MODULE_IN_IMPORTS_AST_QUERY = 'Identifier[name=imports] ~ ArrayLiteralExpression:has(Identifier[name=BrowserModule])';
    const IS_COMMON_MODULE_IMPORTED_AST_QUERY = 'ImportDeclaration:has(ImportSpecifier:has(Identifier[name=CommonModule]))';
    const IS_COMMON_MODULE_IN_IMPORTS_AST_QUERY = 'Identifier[name=imports] ~ ArrayLiteralExpression:has(Identifier[name=CommonModule])';
    const BROWSER_MODULE_POS_AST_QUERY = 'Identifier[name=imports] ~ ArrayLiteralExpression > Identifier[name=BrowserModule]';
    let ast = tsquery_1.tsquery.ast(remoteEntryModule);
    const importsArrayWithBrowserModule = (0, tsquery_1.tsquery)(ast, IS_BROWSER_MODULE_IN_IMPORTS_AST_QUERY, { visitAllChildren: true });
    const commonModuleImportsNode = (0, tsquery_1.tsquery)(ast, IS_COMMON_MODULE_IN_IMPORTS_AST_QUERY, { visitAllChildren: true });
    const commonModuleImportedInFileNode = (0, tsquery_1.tsquery)(ast, IS_COMMON_MODULE_IMPORTED_AST_QUERY, { visitAllChildren: true });
    const hasBrowserModule = importsArrayWithBrowserModule && importsArrayWithBrowserModule.length > 0;
    const needsCommonModuleInImports = !commonModuleImportsNode || commonModuleImportsNode.length < 1;
    const needsCommonModuleImportStatement = !commonModuleImportedInFileNode ||
        commonModuleImportedInFileNode.length < 1;
    if (!hasBrowserModule) {
        if (needsCommonModuleInImports && needsCommonModuleImportStatement) {
            // no browser module and no common module imported
            const IMPORTS_ARRAY_POS_AST_QUERY = 'Identifier[name=imports] ~ ArrayLiteralExpression';
            const importsArrayNode = (0, tsquery_1.tsquery)(ast, IMPORTS_ARRAY_POS_AST_QUERY, {
                visitAllChildren: true,
            })[0];
            const updatedRemoteEntry = `import { CommonModule } from '@angular/common';\n${remoteEntryModule.slice(0, importsArrayNode.getStart() + 1)}\nCommonModule,${remoteEntryModule.slice(importsArrayNode.getStart() + 1)}`;
            return updatedRemoteEntry;
        }
        else {
            return remoteEntryModule;
        }
    }
    const browserModuleNode = (0, tsquery_1.tsquery)(ast, BROWSER_MODULE_POS_AST_QUERY, {
        visitAllChildren: true,
    })[0];
    const updatedRemoteEntryModule = `${needsCommonModuleImportStatement
        ? `import { CommonModule } from '@angular/common';\n`
        : ``}${remoteEntryModule.slice(0, browserModuleNode.getStart())}${needsCommonModuleInImports ? `CommonModule` : ``}${remoteEntryModule.slice(browserModuleNode.getEnd() + (needsCommonModuleInImports ? 0 : 1))}`;
    return updatedRemoteEntryModule;
}
exports.replaceBrowserModuleWithCommonFromRemoteEntry = replaceBrowserModuleWithCommonFromRemoteEntry;
function switchToES2020(tree, projects) {
    for (const projectName of Object.keys(projects)) {
        const { root } = (0, devkit_1.readProjectConfiguration)(tree, projectName);
        let tsConfigPath = tree.exists((0, devkit_1.joinPathFragments)(root, `tsconfig.app.json`))
            ? (0, devkit_1.joinPathFragments)(root, `tsconfig.app.json`)
            : (0, devkit_1.joinPathFragments)(root, `tsconfig.json`);
        (0, devkit_1.updateJson)(tree, tsConfigPath, (json) => (Object.assign(Object.assign({}, json), { compilerOptions: Object.assign(Object.assign({}, json.compilerOptions), { target: 'ES2020' }) })));
    }
}
function turnMinimizeOn(tree, projects) {
    for (const webpackPath of Object.values(projects)) {
        let webpackConfig = tree.read(webpackPath, 'utf-8');
        tree.write(webpackPath, modifyConfigToUseMinimizeOptimization(webpackConfig));
    }
}
function modifyConfigToUseMinimizeOptimization(webpackConfig) {
    const OPTIMIZATION_OBJECT_AST_QUERY = 'PropertyAssignment:has(Identifier[name=optimization]) > ObjectLiteralExpression';
    let ast = tsquery_1.tsquery.ast(webpackConfig);
    const optimizationObjectNode = (0, tsquery_1.tsquery)(ast, OPTIMIZATION_OBJECT_AST_QUERY, {
        visitAllChildren: true,
    })[0];
    const minimizeTrueNode = (0, tsquery_1.tsquery)(optimizationObjectNode, 'Identifier[name=minimize] ~ TrueKeyword', { visitAllChildren: true });
    if (minimizeTrueNode && minimizeTrueNode.length > 0) {
        // it's already turned on
        return webpackConfig;
    }
    const minimizeFalseNode = (0, tsquery_1.tsquery)(optimizationObjectNode, 'Identifier[name=minimize] ~ FalseKeyword', { visitAllChildren: true });
    if (minimizeFalseNode && minimizeFalseNode.length > 0) {
        // it exists but it's set to false, so flip it
        webpackConfig = `${webpackConfig.slice(0, minimizeFalseNode[0].getStart())}true${webpackConfig.slice(minimizeFalseNode[0].getEnd())}`;
        return webpackConfig;
    }
    return webpackConfig;
}
exports.modifyConfigToUseMinimizeOptimization = modifyConfigToUseMinimizeOptimization;
function useShareHelper(tree, projects) {
    for (const webpackPath of Object.values(projects)) {
        let webpackConfig = tree.read(webpackPath, 'utf-8');
        tree.write(webpackPath, modifyConfigToUseShareHelper(webpackConfig));
    }
}
function modifyConfigToUseShareHelper(webpackConfig) {
    const SHARE_CALL_AST_QUERY = 'CallExpression:has(Identifier[name=share])';
    const MODULE_EXPORTS_AST_QUERY = 'ExpressionStatement:has(BinaryExpression:has(PropertyAccessExpression:has(Identifier[name=module], Identifier[name=exports])))';
    const SHARED_OBJECT_AST_QUERY = 'PropertyAssignment:has(Identifier[name=shared]) > ObjectLiteralExpression';
    let ast = tsquery_1.tsquery.ast(webpackConfig);
    const shareCall = (0, tsquery_1.tsquery)(ast, SHARE_CALL_AST_QUERY, {
        visitAllChildren: true,
    });
    if (shareCall && shareCall.length > 0) {
        // skip this project if it's already using share
        return webpackConfig;
    }
    const sharedObject = (0, tsquery_1.tsquery)(ast, SHARED_OBJECT_AST_QUERY, {
        visitAllChildren: true,
    });
    if (!sharedObject || sharedObject.length < 1) {
        // skip because there are no libs being shared
        return webpackConfig;
    }
    const sharedObjectNode = sharedObject[0];
    webpackConfig = `${webpackConfig.slice(0, sharedObjectNode.getStart())}share(${webpackConfig.slice(sharedObjectNode.getStart(), sharedObjectNode.getEnd())})${webpackConfig.slice(sharedObjectNode.getEnd())}`;
    // wrap the shared libs in the function
    ast = tsquery_1.tsquery.ast(webpackConfig);
    const moduleExportsStatement = (0, tsquery_1.tsquery)(ast, MODULE_EXPORTS_AST_QUERY, {
        visitAllChildren: true,
    })[0];
    webpackConfig = `${webpackConfig.slice(0, moduleExportsStatement.getStart())}const share = mf.share;\nmf.setInferVersion(true);\n${webpackConfig.slice(moduleExportsStatement.getStart())}`;
    return webpackConfig;
}
exports.modifyConfigToUseShareHelper = modifyConfigToUseShareHelper;
//# sourceMappingURL=update-mfe-configs.js.map