export declare const correctConfig = "const ModuleFederationPlugin = require('webpack/lib/container/ModuleFederationPlugin');\nconst mf = require('@angular-architects/module-federation/webpack');\nconst path = require('path');\n\n/**\n * We use the NX_TSCONFIG_PATH environment variable when using the @nrwl/angular:webpack-browser\n * builder as it will generate a temporary tsconfig file which contains any required remappings of\n * shared libraries.\n * A remapping will occur when a library is buildable, as webpack needs to know the location of the\n * built files for the buildable library.\n * This NX_TSCONFIG_PATH environment variable is set by the @nrwl/angular:webpack-browser and it contains\n * the location of the generated temporary tsconfig file.\n */\nconst tsConfigPath =\n  process.env.NX_TSCONFIG_PATH ??\n  path.join(__dirname, '../../tsconfig.base.json');\n\nconst workspaceRootPath = path.join(__dirname, '../../');\nconst sharedMappings = new mf.SharedMappings();\nsharedMappings.register(\n  tsConfigPath,\n  [\n    /* mapped paths to share */\n  ],\n  workspaceRootPath\n);\n\nconst share = mf.share;\nmf.setInferVersion(true);\nmodule.exports = {\n  output: {\n    uniqueName: 'host',\n    publicPath: 'auto',\n  },\n  optimization: {\n    runtimeChunk: false,\n  },\n  experiments: {\n    outputModule: true,\n  },\n  resolve: {\n    alias: {\n      ...sharedMappings.getAliases(),\n    },\n  },\n  plugins: [\n    new ModuleFederationPlugin({\n      remotes: {},\n      shared: share({\n        '@angular/core': {\n          singleton: true,\n          strictVersion: true,\n          requiredVersion: 'auto',\n          includeSecondaries: true,\n        },\n        '@angular/common': {\n          singleton: true,\n          strictVersion: true,\n          requiredVersion: 'auto',\n          includeSecondaries: true,\n        },\n        '@angular/common/http': {\n          singleton: true,\n          strictVersion: true,\n          requiredVersion: 'auto',\n          includeSecondaries: true,\n        },\n        '@angular/router': {\n          singleton: true,\n          strictVersion: true,\n          requiredVersion: 'auto',\n          includeSecondaries: true,\n        },\n        rxjs: {\n          singleton: true,\n          strictVersion: true,\n          requiredVersion: 'auto',\n          includeSecondaries: true,\n        },\n        ...sharedMappings.getDescriptors(),\n      }),\n      library: {\n        type: 'module',\n      },\n    }),\n    sharedMappings.getPlugin(),\n  ],\n};";
export declare const shareConfig: {
    correct: string;
    incorrect: string;
};
export declare const optimizationConfig: {
    correct: string;
    incorrectMissing: string;
    incorrectFalse: string;
};
export declare const remoteEntryModule: {
    correct: string;
    noBrowserOrCommonModule: string;
    correctWithNoBrowserOrCommonModule: string;
    onlyBrowserModule: string;
    browserModuleWithCommonImportedInFile: string;
    browserModuleWithCommonImportedInArray: string;
    correctBrowserModuleWithCommonImportedInArray: string;
    correctBrowserModuleWithCommonImportedInFile: string;
};
