"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.addPublicHost = exports.removeRemoteName = exports.addLibraryModuleType = exports.addExperimentsObject = void 0;
const tslib_1 = require("tslib");
const devkit_1 = require("@nrwl/devkit");
const tsquery_1 = require("@phenomnomnominal/tsquery");
const executor_options_utils_1 = require("@nrwl/workspace/src/utilities/executor-options-utils");
function default_1(tree) {
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        const NRWL_WEBPACK_BROWSER_BUILDER = '@nrwl/angular:webpack-browser';
        const CUSTOM_WEBPACK_OPTION = 'customWebpackConfig';
        const projects = [];
        (0, executor_options_utils_1.forEachExecutorOptions)(tree, NRWL_WEBPACK_BROWSER_BUILDER, (opts, projectName) => {
            var _a;
            // Update the webpack config
            const webpackPath = (_a = opts[CUSTOM_WEBPACK_OPTION]) === null || _a === void 0 ? void 0 : _a.path;
            if (!webpackPath || !tree.exists(webpackPath)) {
                devkit_1.logger.warn(`Webpack config file for project: ${projectName} does not exist. Skipping project.`);
                return;
            }
            const webpackConfig = tree.read(webpackPath, 'utf-8');
            const ast = tsquery_1.tsquery.ast(webpackConfig);
            const moduleFederationWebpackConfig = (0, tsquery_1.tsquery)(ast, 'Identifier[name=ModuleFederationPlugin]', {
                visitAllChildren: true,
            });
            if (!moduleFederationWebpackConfig ||
                moduleFederationWebpackConfig.length === 0) {
                return;
            }
            projects.push(projectName);
            let updatedWebpackFile = addExperimentsObject(webpackConfig);
            updatedWebpackFile = addLibraryModuleType(updatedWebpackFile);
            updatedWebpackFile = removeRemoteName(updatedWebpackFile);
            tree.write(webpackPath, updatedWebpackFile);
        });
        addPublicHost(tree, projects);
        yield (0, devkit_1.formatFiles)(tree);
    });
}
exports.default = default_1;
function addExperimentsObject(webpackConfig) {
    const WEBPACK_EXPERIMENTS_QUERY = 'PropertyAssignment > Identifier[name=experiments] ~ ObjectLiteralExpression';
    const ast = tsquery_1.tsquery.ast(webpackConfig);
    const webpackExperimentsNode = (0, tsquery_1.tsquery)(ast, WEBPACK_EXPERIMENTS_QUERY, {
        visitAllChildren: true,
    });
    if (webpackExperimentsNode && webpackExperimentsNode.length > 0) {
        if (webpackExperimentsNode[0].getText().includes('outputModule')) {
            return webpackConfig;
        }
        return `${webpackConfig.slice(0, webpackExperimentsNode[0].getStart() + 1)}\noutputModule: true,${webpackConfig.slice(webpackExperimentsNode[0].getStart() + 1)}`;
    }
    const WEBPACK_EXPORT = 'module.exports = {';
    const openingBracePos = webpackConfig.indexOf(WEBPACK_EXPORT) + WEBPACK_EXPORT.length;
    return `${webpackConfig.slice(0, openingBracePos)}
  experiments: {
    outputModule: true  
  },${webpackConfig.slice(openingBracePos)}`;
}
exports.addExperimentsObject = addExperimentsObject;
function addLibraryModuleType(webpackConfig) {
    const LIBRARY_NODE_QUERY = 'PropertyAssignment > Identifier[name=library] ~ ObjectLiteralExpression';
    const ast = tsquery_1.tsquery.ast(webpackConfig);
    const libraryModuleNode = (0, tsquery_1.tsquery)(ast, LIBRARY_NODE_QUERY);
    if (libraryModuleNode && libraryModuleNode.length > 0) {
        return webpackConfig;
    }
    const MODULE_FEDERATION_PLUGIN_INSTANTIATION = 'new ModuleFederationPlugin({';
    const openingBracePos = webpackConfig.indexOf(MODULE_FEDERATION_PLUGIN_INSTANTIATION) +
        +MODULE_FEDERATION_PLUGIN_INSTANTIATION.length;
    return `${webpackConfig.slice(0, openingBracePos)}
  library: {
      type: 'module'
  },${webpackConfig.slice(openingBracePos)}`;
}
exports.addLibraryModuleType = addLibraryModuleType;
function removeRemoteName(webpackConfig) {
    const REMOTES_QUERY = 'Identifier[name=remotes] ~ ObjectLiteralExpression';
    const ast = tsquery_1.tsquery.ast(webpackConfig);
    const remotesObjectNode = (0, tsquery_1.tsquery)(ast, REMOTES_QUERY, {
        visitAllChildren: true,
    })[0];
    if (!remotesObjectNode) {
        return webpackConfig;
    }
    const remoteProps = (0, tsquery_1.tsquery)(remotesObjectNode, 'PropertyAssignment', {
        visitAllChildren: true,
    });
    const updatedRemoteProps = [];
    for (const prop of remoteProps) {
        const stringValue = (0, tsquery_1.tsquery)(prop, 'StringLiteral', {
            visitAllChildren: true,
        })[0];
        if (!stringValue.getText().match(/\w*@*http/)) {
            continue;
        }
        const identifier = (0, tsquery_1.tsquery)(prop, 'Identifier', {
            visitAllChildren: true,
        })[0];
        const updatedRemoteStringValue = stringValue
            .getText()
            .slice(stringValue.getText().indexOf('@') + 1, -1);
        updatedRemoteProps.push(`${identifier.getText()}: '${updatedRemoteStringValue}'`);
    }
    const updatedRemotesObject = `{
    ${updatedRemoteProps.join(',\n')}
  }`;
    return `${webpackConfig.slice(0, remotesObjectNode.getStart())}${updatedRemotesObject}${webpackConfig.slice(remotesObjectNode.getEnd())}`;
}
exports.removeRemoteName = removeRemoteName;
function addPublicHost(tree, projects) {
    var _a, _b;
    for (const projectName of projects) {
        const project = (0, devkit_1.readProjectConfiguration)(tree, projectName);
        const updatedProject = Object.assign(Object.assign({}, project), { targets: Object.assign(Object.assign({}, project.targets), { serve: Object.assign(Object.assign({}, project.targets.serve), { options: Object.assign(Object.assign({}, project.targets.serve.options), { publicHost: `http://localhost:${(_b = (_a = project.targets.serve.options) === null || _a === void 0 ? void 0 : _a.port) !== null && _b !== void 0 ? _b : 4200}` }) }) }) });
        (0, devkit_1.updateProjectConfiguration)(tree, projectName, updatedProject);
    }
}
exports.addPublicHost = addPublicHost;
//# sourceMappingURL=update-mfe-webpack-config.js.map