"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const devkit_1 = require("@nrwl/devkit");
const typescript_1 = require("typescript");
const path_1 = require("path");
const workspace_1 = require("@nrwl/workspace");
const semver_1 = require("semver");
const versions_1 = require("../../utils/versions");
function default_1(tree) {
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        const identifiers = ['hot', 'cold', 'getTestScheduler', 'time'];
        let shouldAddJasmineMarbles = false;
        (0, devkit_1.visitNotIgnoredFiles)(tree, '', (filePath) => {
            if ((0, path_1.extname)(filePath) !== '.ts') {
                return;
            }
            const updated = updateImports(tree, filePath, identifiers, '@nrwl/angular/testing', 'jasmine-marbles');
            shouldAddJasmineMarbles = shouldAddJasmineMarbles || updated;
        });
        if (shouldAddJasmineMarbles) {
            let rxjsVersion;
            try {
                rxjsVersion = (0, workspace_1.checkAndCleanWithSemver)('rxjs', (0, devkit_1.readJson)(tree, 'package.json').dependencies['rxjs']);
            }
            catch (_a) {
                rxjsVersion = (0, workspace_1.checkAndCleanWithSemver)('rxjs', versions_1.rxjsVersion);
            }
            const jasmineMarblesVersion = (0, semver_1.gte)(rxjsVersion, '7.0.0')
                ? '~0.9.1'
                : '~0.8.3';
            (0, devkit_1.addDependenciesToPackageJson)(tree, {}, {
                'jasmine-marbles': jasmineMarblesVersion,
            });
        }
        yield (0, devkit_1.formatFiles)(tree);
    });
}
exports.default = default_1;
function updateImports(tree, filePath, identifiers, oldModule, newModule) {
    const contents = tree.read(filePath).toString();
    const sourceFile = (0, typescript_1.createSourceFile)(filePath, contents, typescript_1.ScriptTarget.Latest);
    let changes = [];
    const identifiersToAdd = [];
    for (const statement of sourceFile.statements) {
        if ((0, typescript_1.isImportDeclaration)(statement) &&
            (0, typescript_1.isStringLiteral)(statement.moduleSpecifier) &&
            statement.moduleSpecifier.text === oldModule &&
            (0, typescript_1.isNamedImports)(statement.importClause.namedBindings)) {
            const remainingElements = [];
            for (const namedBinding of statement.importClause.namedBindings
                .elements) {
                const identifier = namedBinding.name.getText(sourceFile);
                if (!identifiers.includes(namedBinding.name.getText(sourceFile))) {
                    remainingElements.push(namedBinding);
                }
                else {
                    identifiersToAdd.push(identifier);
                }
            }
            if (remainingElements.length ===
                statement.importClause.namedBindings.elements.length) {
                continue;
            }
            else if (remainingElements.length === 0) {
                changes.push({
                    type: devkit_1.ChangeType.Delete,
                    start: statement.getFullStart(),
                    length: statement.getFullWidth(),
                });
            }
            else {
                changes.push({
                    type: devkit_1.ChangeType.Delete,
                    start: statement.importClause.getStart(sourceFile),
                    length: statement.importClause.getWidth(sourceFile),
                }, {
                    type: devkit_1.ChangeType.Insert,
                    index: statement.importClause.getStart(sourceFile),
                    text: `{ ${remainingElements
                        .map((importSpecifier) => importSpecifier.getText(sourceFile))
                        .join(', ')} }`,
                });
            }
        }
    }
    if (identifiersToAdd.length > 0) {
        let afterImports = 0;
        for (const statement of sourceFile.statements) {
            if ((0, typescript_1.isImportDeclaration)(statement)) {
                afterImports = statement.getEnd();
            }
        }
        changes.push({
            type: devkit_1.ChangeType.Insert,
            index: afterImports,
            text: `\nimport { ${Array.from(new Set(identifiersToAdd)).join(', ')} } from '${newModule}';`,
        });
    }
    if (changes.length > 0) {
        tree.write(filePath, (0, devkit_1.applyChangesToString)(contents, changes));
        return true;
    }
    else {
        return false;
    }
}
//# sourceMappingURL=update-testing-imports.js.map