"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const devkit_1 = require("@nrwl/devkit");
const executor_options_utils_1 = require("@nrwl/workspace/src/utilities/executor-options-utils");
function default_1(tree) {
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        const LIBRARY_EXECUTORS = [
            '@nrwl/angular:ng-packagr-lite',
            '@nrwl/angular:package',
        ];
        const projects = (0, devkit_1.getProjects)(tree);
        const tsConfigFilesToUpdate = new Set();
        const ngPackageFilesToUpdate = new Set();
        LIBRARY_EXECUTORS.forEach((executor) => {
            (0, executor_options_utils_1.forEachExecutorOptions)(tree, executor, (opts, projectName) => {
                const project = projects.get(projectName);
                // UPDATE THE TSCONFIG JSON
                const tsConfigPath = (0, devkit_1.joinPathFragments)(project.root, 'tsconfig.lib.prod.json');
                if (tree.exists(tsConfigPath)) {
                    tsConfigFilesToUpdate.add(tsConfigPath);
                }
                const ngPackageFilePath = (0, devkit_1.joinPathFragments)(project.root, 'ng-package.json');
                if (tree.exists(ngPackageFilePath)) {
                    ngPackageFilesToUpdate.add(ngPackageFilePath);
                }
            });
        });
        for (const tsConfigPath of tsConfigFilesToUpdate) {
            (0, devkit_1.updateJson)(tree, tsConfigPath, (json) => {
                if (json.angularCompilerOptions &&
                    'enableIvy' in json.angularCompilerOptions) {
                    json.angularCompilerOptions.enableIvy = undefined;
                }
                if (json.angularCompilerOptions &&
                    !('compilationMode' in json.angularCompilerOptions)) {
                    json.angularCompilerOptions.compilationMode = 'partial';
                }
                return json;
            });
        }
        for (const ngPackagePath of ngPackageFilesToUpdate) {
            (0, devkit_1.updateJson)(tree, ngPackagePath, (json) => {
                if (json.lib && 'umdModuleIds' in json.lib) {
                    json.lib.umdModuleIds = undefined;
                }
                if (json.lib && 'amdId' in json.lib) {
                    json.lib.amdId = undefined;
                }
                if (json.lib && 'umdId' in json.lib) {
                    json.lib.umdId = undefined;
                }
                return json;
            });
        }
    });
}
exports.default = default_1;
//# sourceMappingURL=update-libraries.js.map