"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.replaceTransformAndAddIgnorePattern = void 0;
const tslib_1 = require("tslib");
const devkit_1 = require("@nrwl/devkit");
const tsquery_1 = require("@phenomnomnominal/tsquery");
function default_1(tree) {
    var _a, _b;
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        const projects = (0, devkit_1.getProjects)(tree);
        const angularProjects = {};
        for (const [projectName, project] of projects.entries()) {
            if (((_a = project.targets) === null || _a === void 0 ? void 0 : _a.test) &&
                ((_b = project.targets) === null || _b === void 0 ? void 0 : _b.test.executor) === '@nrwl/jest:jest') {
                const jestConfigPath = project.targets.test.options && project.targets.test.options.jestConfig;
                if (!jestConfigPath || !tree.exists(jestConfigPath)) {
                    continue;
                }
                const jestConfig = tree.read(jestConfigPath, 'utf-8');
                if (jestConfig.includes('jest-preset-angular')) {
                    angularProjects[projectName] = [jestConfigPath, jestConfig];
                }
            }
        }
        yield (0, devkit_1.formatFiles)(tree);
        for (const [_, [jestConfigPath, jestFileContents]] of Object.entries(angularProjects)) {
            tree.write(jestConfigPath, replaceTransformAndAddIgnorePattern(jestFileContents));
        }
        yield (0, devkit_1.formatFiles)(tree);
    });
}
exports.default = default_1;
function replaceTransformAndAddIgnorePattern(fileContents) {
    let updatedFileContents = updateTransformProperty(fileContents);
    updatedFileContents = updateTransformIgnorePattern(updatedFileContents);
    if (fileContents === updatedFileContents) {
        return updatedFileContents;
    }
    return updatedFileContents;
}
exports.replaceTransformAndAddIgnorePattern = replaceTransformAndAddIgnorePattern;
function updateTransformProperty(fileContents) {
    const JEST_PRESET_ANGULAR_AST_QUERY = 'Identifier[name=transform] ~ ObjectLiteralExpression > PropertyAssignment:has(StringLiteral[value=jest-preset-angular])';
    const TRANSFORMER_STRING = "'^.+\\.(ts|mjs|js|html)$': 'jest-preset-angular'";
    let ast = tsquery_1.tsquery.ast(fileContents);
    const transformerExpressionNode = (0, tsquery_1.tsquery)(ast, JEST_PRESET_ANGULAR_AST_QUERY, {
        visitAllChildren: true,
    })[0];
    if (!transformerExpressionNode) {
        return fileContents;
    }
    const transformerIndex = transformerExpressionNode.pos;
    const transformerEndIndex = transformerExpressionNode.end;
    return `${fileContents.slice(0, transformerIndex)}\n${TRANSFORMER_STRING}${fileContents.slice(transformerEndIndex)}`;
}
function updateTransformIgnorePattern(fileContents) {
    const TRANSFORM_OBJECT_AST_QUERY = 'PropertyAssignment:has(Identifier[name=transform])';
    let TRANSFORM_IGNORE_PATTERN_STRING = "transformIgnorePatterns: ['node_modules/(?!.*\\.mjs$)'],";
    if (fileContents.includes("transformIgnorePatterns: ['node_modules/(?!.*\\.mjs$)']")) {
        return fileContents;
    }
    const ast = tsquery_1.tsquery.ast(fileContents);
    const transformObjectNode = (0, tsquery_1.tsquery)(ast, TRANSFORM_OBJECT_AST_QUERY, {
        visitAllChildren: true,
    })[0];
    if (!transformObjectNode) {
        return fileContents;
    }
    let transformEndIndex = transformObjectNode.getEnd();
    if (fileContents.charAt(transformEndIndex) == ',') {
        transformEndIndex = transformObjectNode.getEnd() + 1;
        TRANSFORM_IGNORE_PATTERN_STRING = `\n${TRANSFORM_IGNORE_PATTERN_STRING}`;
    }
    else {
        TRANSFORM_IGNORE_PATTERN_STRING = `,\n${TRANSFORM_IGNORE_PATTERN_STRING}`;
    }
    return `${fileContents.slice(0, transformEndIndex)}${TRANSFORM_IGNORE_PATTERN_STRING}${fileContents.slice(transformEndIndex)}`;
}
//# sourceMappingURL=update-angular-jest-config.js.map