"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const devkit_1 = require("@nrwl/devkit");
const executor_options_utils_1 = require("@nrwl/workspace/src/utilities/executor-options-utils");
function default_1(tree) {
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        (0, executor_options_utils_1.forEachExecutorOptions)(tree, '@nrwl/angular:webpack-server', (options, projectName, targetName, configurationName) => {
            const projectConfiguration = (0, devkit_1.readProjectConfiguration)(tree, projectName);
            const config = configurationName
                ? projectConfiguration.targets[targetName].configurations[configurationName]
                : projectConfiguration.targets[targetName].options;
            delete config.optimization;
            delete config.aot;
            delete config.progress;
            delete config.deployUrl;
            delete config.sourceMap;
            delete config.vendorChunk;
            delete config.commonChunk;
            delete config.baseHref;
            delete config.servePathDefaultWarning;
            delete config.hmrWarning;
            delete config.extractCss;
            (0, devkit_1.updateProjectConfiguration)(tree, projectName, projectConfiguration);
        });
        (0, executor_options_utils_1.forEachExecutorOptions)(tree, '@nrwl/angular:webpack-browser', (options, projectName, targetName, configurationName) => {
            const projectConfiguration = (0, devkit_1.readProjectConfiguration)(tree, projectName);
            const config = configurationName
                ? projectConfiguration.targets[targetName].configurations[configurationName]
                : projectConfiguration.targets[targetName];
            delete config.extractCss;
            (0, devkit_1.updateProjectConfiguration)(tree, projectName, projectConfiguration);
        });
    });
}
exports.default = default_1;
//# sourceMappingURL=update-angular-config.js.map