"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.findInvalidLibs = exports.findBuildableAndPublishableLibs = void 0;
const tslib_1 = require("tslib");
const devkit_1 = require("@nrwl/devkit");
function default_1(tree) {
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        const tsconfigPath = getBaseTsConfigPath(tree);
        if (!tree.exists(tsconfigPath)) {
            devkit_1.logger.error('Could not find `tsconfig.base.json` or `tsconfig.json` at the root of the workspace. Skipping this migration...');
            return;
        }
        const possibleAffectedLibs = findBuildableAndPublishableLibs(tree);
        const invalidLibs = findInvalidLibs(tree, possibleAffectedLibs, tsconfigPath);
        fixLibs(tree, invalidLibs, tsconfigPath);
        yield (0, devkit_1.formatFiles)(tree);
    });
}
exports.default = default_1;
function findBuildableAndPublishableLibs(tree) {
    const projects = (0, devkit_1.getProjects)(tree);
    const buildableLibs = [];
    const publishableLibs = [];
    for (const [name, project] of projects) {
        for (const target of Object.values(project.targets || {})) {
            if (target.executor === '@nrwl/angular:package') {
                publishableLibs.push(project);
            }
            else if (target.executor === '@nrwl/angular:ng-packagr-lite') {
                buildableLibs.push(project);
            }
        }
    }
    return { buildableLibs, publishableLibs };
}
exports.findBuildableAndPublishableLibs = findBuildableAndPublishableLibs;
function findInvalidLibs(tree, libs, tsconfigPath) {
    const { compilerOptions } = (0, devkit_1.readJson)(tree, tsconfigPath);
    const { paths: tsConfigPaths } = compilerOptions;
    const invalidBuildableLibs = libs.buildableLibs.filter((lib) => checkInvalidLib(tree, lib, tsConfigPaths));
    const invalidPublishableLibs = libs.publishableLibs.filter((lib) => checkInvalidLib(tree, lib, tsConfigPaths));
    return {
        buildableLibs: invalidBuildableLibs,
        publishableLibs: invalidPublishableLibs,
    };
}
exports.findInvalidLibs = findInvalidLibs;
function checkInvalidLib(tree, lib, tsConfigPaths) {
    const { name } = (0, devkit_1.readJson)(tree, (0, devkit_1.joinPathFragments)(lib.root, 'package.json'));
    return !tsConfigPaths[name];
}
function fixLibs(tree, { buildableLibs, publishableLibs }, tsconfigFilePath) {
    const { compilerOptions } = (0, devkit_1.readJson)(tree, tsconfigFilePath);
    const { paths: tsConfigPaths } = compilerOptions;
    buildableLibs.map((lib) => fixBuildableLib(tree, lib, tsConfigPaths));
    publishableLibs.map((lib) => fixPublishableLib(tree, lib, tsConfigPaths, tsconfigFilePath));
}
function fixBuildableLib(tree, lib, tsConfigPaths) {
    const srcRoot = (0, devkit_1.joinPathFragments)(lib.sourceRoot, 'index.ts');
    for (const [validPackageName, tsLibSrcRoot] of Object.entries(tsConfigPaths)) {
        if (tsLibSrcRoot[0] === srcRoot) {
            (0, devkit_1.updateJson)(tree, (0, devkit_1.joinPathFragments)(lib.root, 'package.json'), (pkgJson) => {
                pkgJson.name = validPackageName;
                return pkgJson;
            });
            break;
        }
    }
}
function fixPublishableLib(tree, lib, tsConfigPaths, tsconfigFilePath) {
    const srcRoot = (0, devkit_1.joinPathFragments)(lib.sourceRoot, 'index.ts');
    const { name: pkgName } = (0, devkit_1.readJson)(tree, (0, devkit_1.joinPathFragments)(lib.root, 'package.json'));
    const pkgNameParts = pkgName.split('/');
    if (Array.isArray(pkgNameParts) && pkgNameParts.length > 2) {
        devkit_1.logger.warn(`Your publishable package ${pkgName} is an invalid NPM Package name. Please ensure it only contains one '/'.`);
        devkit_1.logger.warn(`The affected package.json is at '${(0, devkit_1.joinPathFragments)(lib.root, 'package.json')}'`);
    }
    for (const [invalidPathKey, tsLibSrcRoot] of Object.entries(tsConfigPaths)) {
        if (tsLibSrcRoot[0] === srcRoot) {
            (0, devkit_1.updateJson)(tree, tsconfigFilePath, (tsconfig) => {
                tsconfig.compilerOptions.paths[invalidPathKey] = undefined;
                tsconfig.compilerOptions.paths[pkgName] = tsLibSrcRoot;
                return tsconfig;
            });
            break;
        }
    }
}
function getBaseTsConfigPath(tree) {
    return tree.exists('tsconfig.base.json')
        ? 'tsconfig.base.json'
        : 'tsconfig.json';
}
//# sourceMappingURL=update-invalid-import-paths.js.map