"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const devkit_1 = require("@nrwl/devkit");
const optionsToUpdate = [
    ['aot', false, true],
    ['vendorChunk', true, false],
    ['extractLicenses', false, true],
    ['buildOptimizer', false, true],
    ['sourceMap', true, false],
    ['optimization', false, true],
    ['namedChunks', true, false],
];
function updateAngularConfig(host) {
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        const projects = (0, devkit_1.getProjects)(host);
        for (const [name, project] of projects) {
            for (const target of Object.values(project.targets || {})) {
                if (target.executor === '@nrwl/angular:webpack-browser') {
                    updateOptions(target, optionsToUpdate);
                    for (const options of allTargetOptions(target)) {
                        delete options.experimentalRollupPass;
                        delete options.lazyModules;
                        delete options.forkTypeChecker;
                    }
                }
            }
            (0, devkit_1.updateProjectConfiguration)(host, name, project);
        }
        yield (0, devkit_1.formatFiles)(host);
    });
}
exports.default = updateAngularConfig;
function* allTargetOptions(target) {
    if (target.options) {
        yield target.options;
    }
    if (!target.configurations) {
        return;
    }
    for (const [, options] of Object.entries(target.configurations)) {
        if (options !== undefined) {
            yield options;
        }
    }
}
function updateOptions(target, options) {
    if (!target.options) {
        target.options = {};
    }
    const configurationOptions = target.configurations && Object.values(target.configurations);
    for (const [optionName, oldDefault, newDefault] of options) {
        let value = target.options[optionName];
        if (value === newDefault) {
            // Value is same as new default
            delete target.options[optionName];
        }
        else if (value === undefined) {
            // Value is not defined, hence the default in the executor was used.
            target.options[optionName] = oldDefault;
            value = oldDefault;
        }
        // Remove overrides in configurations which are no longer needed.
        configurationOptions === null || configurationOptions === void 0 ? void 0 : configurationOptions.filter((o) => o && o[optionName] === value).forEach((o) => o && delete o[optionName]);
    }
}
//# sourceMappingURL=update-webpack-browser-config.js.map