"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const devkit_1 = require("@nrwl/devkit");
const semver_1 = require("semver");
const path_1 = require("path");
const executor_options_utils_1 = require("@nrwl/workspace/src/utilities/executor-options-utils");
function default_1(tree) {
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        let storybookVersion;
        try {
            storybookVersion = require('@storybook/core/package.json').version;
        }
        catch (_a) { }
        if (!storybookVersion) {
            return;
        }
        if ((0, semver_1.lt)(storybookVersion, '6.2.0')) {
            devkit_1.logger.error((0, devkit_1.stripIndents) `NX Could not migrate to Angular 12
      Angular 12 uses Webpack 5.
      This workspace uses Storybook ${storybookVersion} which does not support Webpack 5.
      Storybook 6.2+ is required to support Webpack 5.
      See our documentation on migrating to Storybook 6:
      https://nx.dev/storybook/overview-angular#upgrading-to-storybook-6-using-the-nx-migration-generator
    `);
            throw new Error('Could not migrate to Angular 12');
        }
        let updated;
        (0, executor_options_utils_1.forEachExecutorOptions)(tree, '@nrwl/storybook:storybook', (options) => {
            var _a, _b;
            if (options.uiFramework !== '@storybook/angular') {
                return;
            }
            const configFolder = (_a = options === null || options === void 0 ? void 0 : options.config) === null || _a === void 0 ? void 0 : _a.configFolder;
            if (!configFolder) {
                return;
            }
            const configPath = (0, path_1.join)(configFolder, 'main.js');
            if (!tree.exists(configPath)) {
                devkit_1.logger.warn(`Could not migrate ${configPath} to use webpack 5. The config.core.builder should be set to "webpack5". See https://gist.github.com/shilman/8856ea1786dcd247139b47b270912324#upgrade`);
                return;
            }
            updated = true;
            const originalContents = tree.read(configPath).toString();
            const configureWebpack5 = `module.exports.core = { ...module.exports.core, builder: 'webpack5' };`;
            try {
                const config = require((0, path_1.join)(tree.root, configPath));
                if (((_b = config === null || config === void 0 ? void 0 : config.core) === null || _b === void 0 ? void 0 : _b.builder) !== 'webpack5') {
                    tree.write(configPath, originalContents + '\n' + configureWebpack5);
                }
            }
            catch (_c) { }
        });
        const installTask = updated
            ? (0, devkit_1.addDependenciesToPackageJson)(tree, {}, {
                '@storybook/builder-webpack5': storybookVersion,
            })
            : () => { };
        yield (0, devkit_1.formatFiles)(tree);
        return installTask;
    });
}
exports.default = default_1;
//# sourceMappingURL=update-storybook.js.map