"use strict";
// This migration is mostly copied from https://github.com/angular-eslint/angular-eslint/blob/3c5a9d43264c9cbdd8fe8f2ebb19c613396386c2/packages/schematics/src/migrations/update-12-0-0/update-12-0-0.ts
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const devkit_1 = require("@nrwl/devkit");
const path_1 = require("path");
function default_1(tree) {
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        (0, devkit_1.visitNotIgnoredFiles)(tree, '', (file) => {
            if ((0, path_1.basename)(file) !== '.eslintrc.json') {
                return;
            }
            (0, devkit_1.updateJson)(tree, file, (eslintJson) => {
                migrateAngularEsLintRules(eslintJson);
                return eslintJson;
            });
        });
        yield (0, devkit_1.formatFiles)(tree);
    });
}
exports.default = default_1;
function migrateAngularEsLintRules({ overrides, rules }) {
    var _a;
    migrateToAccessibilityLabelHasAssociatedControlSchema(rules === null || rules === void 0 ? void 0 : rules['@angular-eslint/template/accessibility-label-for']);
    migrateToAccessibilityLabelHasAssociatedControlName(rules);
    addEqeqeqIfNeeded(rules);
    for (const o of overrides !== null && overrides !== void 0 ? overrides : []) {
        migrateToAccessibilityLabelHasAssociatedControlSchema((_a = o.rules) === null || _a === void 0 ? void 0 : _a['@angular-eslint/template/accessibility-label-for']);
        migrateToAccessibilityLabelHasAssociatedControlName(o.rules);
        addEqeqeqIfNeeded(o.rules);
    }
}
function migrateToAccessibilityLabelHasAssociatedControlName(rules) {
    if (!rules)
        return;
    const accessibilityLabelForRule = rules['@angular-eslint/template/accessibility-label-for'];
    delete rules['@angular-eslint/template/accessibility-label-for'];
    rules['@angular-eslint/template/accessibility-label-has-associated-control'] =
        accessibilityLabelForRule;
}
function migrateToAccessibilityLabelHasAssociatedControlSchema(rule) {
    if (!Array.isArray(rule) || rule.length !== 2)
        return;
    const [, currentSchema] = rule;
    rule[1] = {
        controlComponents: currentSchema.controlComponents,
        labelComponents: currentSchema.labelComponents.map((selector) => {
            return { inputs: currentSchema.labelAttributes, selector };
        }),
    };
}
function addEqeqeqIfNeeded(rules) {
    if (!rules ||
        !rules['@angular-eslint/template/no-negated-async'] ||
        rules['@angular-eslint/template/eqeqeq']) {
        return;
    }
    rules['@angular-eslint/template/eqeqeq'] = 'error';
}
//# sourceMappingURL=update-angular-eslint-rules.js.map