"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const devkit_1 = require("@nrwl/devkit");
function convertWebpackBrowserBuildTargetToDelegateBuild(host) {
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        const projects = (0, devkit_1.getProjects)(host);
        for (const [projectName, project] of projects) {
            const webpackBrowserTargets = Object.values(project.targets || {}).filter((target) => target.executor === '@nrwl/angular:webpack-browser');
            for (const target of webpackBrowserTargets) {
                const configurationOptions = getTargetConfigurationOptions(target);
                const buildTargetName = getBuildTargetNameFromOptions(target.options, configurationOptions);
                if (buildTargetName) {
                    target.executor = '@nrwl/angular:delegate-build';
                    updateTargetsOptions(project, target, buildTargetName);
                    updateTargetsConfigurations(project, projectName, target, buildTargetName, configurationOptions);
                }
            }
            (0, devkit_1.updateProjectConfiguration)(host, projectName, project);
        }
        yield (0, devkit_1.formatFiles)(host);
    });
}
exports.default = convertWebpackBrowserBuildTargetToDelegateBuild;
function cleanupBuildTargetProperties(options) {
    delete options.tsConfig;
    delete options.outputPath;
}
function extractConfigurationBuildTarget(project, target, configuration, buildTarget) {
    var _a;
    if (buildTarget) {
        const buildTargetObj = (0, devkit_1.parseTargetString)(buildTarget);
        return Object.assign(Object.assign({}, buildTargetObj), { configuration: (_a = buildTargetObj.configuration) !== null && _a !== void 0 ? _a : configuration });
    }
    return {
        project: project,
        target: target,
        configuration: configuration,
    };
}
function getBuildTargetNameFromOptions(baseOptions, configurationOptions) {
    if (baseOptions.buildTarget) {
        return (0, devkit_1.parseTargetString)(baseOptions.buildTarget).target;
    }
    for (const [, options] of configurationOptions) {
        if (options.buildTarget) {
            return (0, devkit_1.parseTargetString)(options.buildTarget).target;
        }
    }
}
function getTargetConfigurationOptions(target) {
    const targets = new Map();
    if (target.configurations) {
        for (const [name, options] of Object.entries(target.configurations)) {
            if (options !== undefined) {
                targets.set(name, options);
            }
        }
    }
    return targets;
}
function updateTargetsConfigurations(project, projectName, target, buildTargetName, configurationOptions) {
    for (const [configurationName, options] of configurationOptions) {
        const { buildTarget, tsConfig, outputPath } = options, delegateTargetOptions = tslib_1.__rest(options, ["buildTarget", "tsConfig", "outputPath"]);
        const configurationBuildTarget = extractConfigurationBuildTarget(projectName, buildTargetName, configurationName, buildTarget);
        if (!project.targets[buildTargetName].configurations) {
            project.targets[buildTargetName].configurations = {};
        }
        // Update build target configuration options by overwriting them
        const buildTargetConfigurations = project.targets[buildTargetName].configurations;
        buildTargetConfigurations[configurationBuildTarget.configuration] = Object.assign(Object.assign({}, buildTargetConfigurations[configurationBuildTarget.configuration]), delegateTargetOptions);
        // Delete options already present in the source target
        cleanupBuildTargetProperties(buildTargetConfigurations[configurationBuildTarget.configuration]);
        // Update source target configuration with buildTarget
        target.configurations[configurationName] = {
            buildTarget: (0, devkit_1.targetToTargetString)(configurationBuildTarget),
            tsConfig,
            outputPath,
        };
    }
}
function updateTargetsOptions(project, target, buildTargetName) {
    if (target.options) {
        const _a = target.options, { buildTarget, tsConfig, outputPath } = _a, delegateTargetOptions = tslib_1.__rest(_a, ["buildTarget", "tsConfig", "outputPath"]);
        // Update build target options by overwriting them
        project.targets[buildTargetName].options = Object.assign(Object.assign({}, project.targets[buildTargetName].options), delegateTargetOptions);
        // Delete options already present in the source target
        cleanupBuildTargetProperties(project.targets[buildTargetName].options);
        // Update source target options to only contain what it needs
        target.options = {
            buildTarget,
            tsConfig,
            outputPath,
        };
    }
}
//# sourceMappingURL=convert-webpack-browser-build-target-to-delegate-build.js.map