"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const schematics_1 = require("@angular-devkit/schematics");
const workspace_1 = require("@nrwl/workspace");
const workspace_2 = require("@nrwl/workspace");
const udpateNgccPostinstallScript = (host, context) => {
    (0, workspace_1.updateJsonInTree)('package.json', (json) => {
        if (json.scripts &&
            json.scripts.postinstall &&
            json.scripts.postinstall.includes('ngcc')) {
            // if exists, add execution of this script
            json.scripts.postinstall = json.scripts.postinstall.replace(/(.*)(ngcc --properties es2015 browser module main --first-only --create-ivy-entry-points)(.*)/, '$1ngcc --properties es2015 browser module main$3');
        }
        return json;
    })(host, context);
};
function default_1() {
    return (0, schematics_1.chain)([udpateNgccPostinstallScript, (0, workspace_2.formatFiles)()]);
}
exports.default = default_1;
//# sourceMappingURL=update-ngcc-postinstall.js.map