"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.webWorkerGenerator = void 0;
const tslib_1 = require("tslib");
const devkit_1 = require("@nrwl/devkit");
const ngcli_adapter_1 = require("@nrwl/devkit/ngcli-adapter");
const lib_1 = require("./lib");
function webWorkerGenerator(tree, rawOptions) {
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        const options = (0, lib_1.normalizeOptions)(rawOptions);
        const { skipFormat } = options, schematicOptions = tslib_1.__rest(options, ["skipFormat"]);
        const webWorkerSchematic = (0, ngcli_adapter_1.wrapAngularDevkitSchematic)('@schematics/angular', 'web-worker');
        yield webWorkerSchematic(tree, schematicOptions);
        (0, lib_1.updateTsConfig)(tree, options.project);
        if (!skipFormat) {
            yield (0, devkit_1.formatFiles)(tree);
        }
    });
}
exports.webWorkerGenerator = webWorkerGenerator;
exports.default = webWorkerGenerator;
//# sourceMappingURL=web-worker.js.map