"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.updateTsConfig = void 0;
const devkit_1 = require("@nrwl/devkit");
const typescript_1 = require("@nrwl/workspace/src/utilities/typescript");
function updateTsConfig(tree, project) {
    const { root } = (0, devkit_1.readProjectConfiguration)(tree, project);
    const workerTsConfigPath = (0, devkit_1.joinPathFragments)(root, 'tsconfig.worker.json');
    (0, devkit_1.updateJson)(tree, workerTsConfigPath, (json) => {
        json.extends = (0, typescript_1.getRelativePathToRootTsConfig)(tree, root);
        return json;
    });
}
exports.updateTsConfig = updateTsConfig;
//# sourceMappingURL=update-tsconfig.js.map