"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.addUpgradeToPackageJson = void 0;
const devkit_1 = require("@nrwl/devkit");
const versions_1 = require("../../utils/versions");
function addUpgradeToPackageJson(tree) {
    (0, devkit_1.updateJson)(tree, './package.json', (json) => {
        var _a;
        json.dependencies = Object.assign({ '@angular/upgrade': json.dependencies['@angular/core'], angular: versions_1.angularJsVersion }, ((_a = json.dependencies) !== null && _a !== void 0 ? _a : {}));
        json.dependencies = sortObjectByKeys(json.dependencies);
        return json;
    });
    return () => {
        (0, devkit_1.installPackagesTask)(tree);
    };
}
exports.addUpgradeToPackageJson = addUpgradeToPackageJson;
function sortObjectByKeys(obj) {
    return Object.keys(obj)
        .sort()
        .reduce((result, key) => {
        return Object.assign(Object.assign({}, result), { [key]: obj[key] });
    }, {});
}
//# sourceMappingURL=upgrade.js.map