"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getKnobType = exports.getComponentProps = exports.getInputPropertyDeclarations = void 0;
const typescript_1 = require("@nrwl/workspace/src/utilities/typescript");
const typescript_2 = require("typescript");
const ast_utils_1 = require("../../utils/nx-devkit/ast-utils");
function getInputPropertyDeclarations(tree, path) {
    const file = (0, ast_utils_1.getTsSourceFile)(tree, path);
    const decorators = (0, typescript_1.getSourceNodes)(file).filter((node) => node.kind === typescript_2.SyntaxKind.Decorator);
    return decorators
        .filter((decorator) => (0, typescript_1.findNodes)(decorator, typescript_2.SyntaxKind.Identifier).some((node) => node.getText() === 'Input'))
        .map((node) => node.parent);
}
exports.getInputPropertyDeclarations = getInputPropertyDeclarations;
function getComponentProps(tree, componentPath, getArgsDefaultValueFn) {
    const props = getInputPropertyDeclarations(tree, componentPath).map((node) => {
        const decoratorContent = (0, typescript_1.findNodes)((0, typescript_1.findNodes)(node, typescript_2.SyntaxKind.Decorator).find((n) => n.getText().startsWith('@Input')), typescript_2.SyntaxKind.StringLiteral);
        const name = decoratorContent.length
            ? !decoratorContent[0].getText().includes('.')
                ? decoratorContent[0].getText().slice(1, -1)
                : node.name.getText()
            : node.name.getText();
        const type = getKnobType(node);
        const defaultValue = getArgsDefaultValueFn(node);
        return {
            name,
            type,
            defaultValue,
        };
    });
    return props;
}
exports.getComponentProps = getComponentProps;
function getKnobType(property) {
    if (property.type) {
        const typeName = property.type.getText();
        const typeNameToKnobType = {
            string: 'text',
            number: 'number',
            boolean: 'boolean',
        };
        return typeNameToKnobType[typeName] || 'text';
    }
    if (property.initializer) {
        const initializerKindToKnobType = {
            [typescript_2.SyntaxKind.StringLiteral]: 'text',
            [typescript_2.SyntaxKind.NumericLiteral]: 'number',
            [typescript_2.SyntaxKind.TrueKeyword]: 'boolean',
            [typescript_2.SyntaxKind.FalseKeyword]: 'boolean',
        };
        return initializerKindToKnobType[property.initializer.kind] || 'text';
    }
    return 'text';
}
exports.getKnobType = getKnobType;
//# sourceMappingURL=storybook.js.map