"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.updateModuleBootstrap = void 0;
const devkit_1 = require("@nrwl/devkit");
const ast_utils_1 = require("@nrwl/workspace/src/utilities/ast-utils");
const ast_utils_2 = require("../../../utils/nx-devkit/ast-utils");
function updateModuleBootstrap(tree, options) {
    let { moduleClassName, modulePath, moduleSource } = (0, ast_utils_2.readBootstrapInfo)(tree, options.project);
    moduleSource = (0, ast_utils_1.addParameterToConstructor)(tree, moduleSource, modulePath, {
        className: moduleClassName,
        param: 'private upgrade: UpgradeModule',
    });
    moduleSource = (0, ast_utils_1.addMethod)(tree, moduleSource, modulePath, {
        className: moduleClassName,
        methodHeader: 'ngDoBootstrap(): void',
        body: `
configure${(0, devkit_1.names)(options.name).className}(this.upgrade.injector);
this.upgrade.bootstrap(document.body, ['downgraded', '${options.name}']);
`,
    });
    (0, ast_utils_2.removeFromNgModule)(tree, moduleSource, modulePath, 'bootstrap');
}
exports.updateModuleBootstrap = updateModuleBootstrap;
//# sourceMappingURL=update-module-bootstrap.js.map