"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.addImportsToModule = void 0;
const devkit_1 = require("@nrwl/devkit");
const ast_utils_1 = require("@nrwl/workspace/src/utilities/ast-utils");
const ast_utils_2 = require("../../../utils/nx-devkit/ast-utils");
function addImportsToModule(tree, options) {
    let { moduleClassName, modulePath, moduleSource } = (0, ast_utils_2.readBootstrapInfo)(tree, options.project);
    const { className, fileName } = (0, devkit_1.names)(options.name);
    moduleSource = (0, ast_utils_1.insertImport)(tree, moduleSource, modulePath, `configure${className}, upgradedComponents`, `../${fileName}-setup`);
    moduleSource = (0, ast_utils_1.insertImport)(tree, moduleSource, modulePath, 'UpgradeModule', '@angular/upgrade/static');
    moduleSource = (0, ast_utils_2.addImportToModule)(tree, moduleSource, modulePath, 'UpgradeModule');
    moduleSource = (0, ast_utils_2.addDeclarationToModule)(tree, moduleSource, modulePath, '...upgradedComponents');
    (0, ast_utils_2.addEntryComponents)(tree, moduleSource, modulePath, (0, ast_utils_2.getBootstrapComponent)(moduleSource, moduleClassName));
}
exports.addImportsToModule = addImportsToModule;
//# sourceMappingURL=add-imports-to-module.js.map