"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.storybookConfigurationGenerator = void 0;
const tslib_1 = require("tslib");
const assert_compatible_storybook_version_1 = require("./lib/assert-compatible-storybook-version");
const generate_stories_1 = require("./lib/generate-stories");
const generate_storybook_configuration_1 = require("./lib/generate-storybook-configuration");
const validate_options_1 = require("./lib/validate-options");
function storybookConfigurationGenerator(tree, options) {
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        (0, assert_compatible_storybook_version_1.assertCompatibleStorybookVersion)();
        (0, validate_options_1.validateOptions)(options);
        const storybookGeneratorInstallTask = yield (0, generate_storybook_configuration_1.generateStorybookConfiguration)(tree, options);
        if (options.generateStories) {
            (0, generate_stories_1.generateStories)(tree, options);
        }
        return () => {
            storybookGeneratorInstallTask();
        };
    });
}
exports.storybookConfigurationGenerator = storybookConfigurationGenerator;
exports.default = storybookConfigurationGenerator;
//# sourceMappingURL=storybook-configuration.js.map